import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksServicePrincipalsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/service_principals#application_ids DataDatabricksServicePrincipals#application_ids}
    */
    readonly applicationIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/service_principals#display_name_contains DataDatabricksServicePrincipals#display_name_contains}
    */
    readonly displayNameContains?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/service_principals#id DataDatabricksServicePrincipals#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/service_principals databricks_service_principals}
*/
export declare class DataDatabricksServicePrincipals extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_service_principals";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/service_principals databricks_service_principals} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksServicePrincipalsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksServicePrincipalsConfig);
    private _applicationIds?;
    get applicationIds(): string[];
    set applicationIds(value: string[]);
    resetApplicationIds(): void;
    get applicationIdsInput(): string[] | undefined;
    private _displayNameContains?;
    get displayNameContains(): string;
    set displayNameContains(value: string);
    resetDisplayNameContains(): void;
    get displayNameContainsInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
