import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksSqlWarehousesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouses#id DataDatabricksSqlWarehouses#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouses#ids DataDatabricksSqlWarehouses#ids}
    */
    readonly ids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouses#warehouse_name_contains DataDatabricksSqlWarehouses#warehouse_name_contains}
    */
    readonly warehouseNameContains?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouses databricks_sql_warehouses}
*/
export declare class DataDatabricksSqlWarehouses extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_sql_warehouses";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/sql_warehouses databricks_sql_warehouses} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksSqlWarehousesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksSqlWarehousesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ids?;
    get ids(): string[];
    set ids(value: string[]);
    resetIds(): void;
    get idsInput(): string[] | undefined;
    private _warehouseNameContains?;
    get warehouseNameContains(): string;
    set warehouseNameContains(value: string);
    resetWarehouseNameContains(): void;
    get warehouseNameContainsInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
