import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksTablesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/tables#catalog_name DataDatabricksTables#catalog_name}
    */
    readonly catalogName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/tables#id DataDatabricksTables#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/tables#ids DataDatabricksTables#ids}
    */
    readonly ids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/tables#schema_name DataDatabricksTables#schema_name}
    */
    readonly schemaName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/tables databricks_tables}
*/
export declare class DataDatabricksTables extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_tables";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/tables databricks_tables} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksTablesConfig
    */
    constructor(scope: Construct, id: string, config: DataDatabricksTablesConfig);
    private _catalogName?;
    get catalogName(): string;
    set catalogName(value: string);
    get catalogNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ids?;
    get ids(): string[];
    set ids(value: string[]);
    resetIds(): void;
    get idsInput(): string[] | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    get schemaNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
