import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDatabricksUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/user#id DataDatabricksUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/user#user_id DataDatabricksUser#user_id}
    */
    readonly userId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/d/user#user_name DataDatabricksUser#user_name}
    */
    readonly userName?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/d/user databricks_user}
*/
export declare class DataDatabricksUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "databricks_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/d/user databricks_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDatabricksUserConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataDatabricksUserConfig);
    get alphanumeric(): string;
    get applicationId(): string;
    get displayName(): string;
    get externalId(): string;
    get home(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get repos(): string;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
