import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EntitlementsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/entitlements#allow_cluster_create Entitlements#allow_cluster_create}
    */
    readonly allowClusterCreate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/entitlements#allow_instance_pool_create Entitlements#allow_instance_pool_create}
    */
    readonly allowInstancePoolCreate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/entitlements#databricks_sql_access Entitlements#databricks_sql_access}
    */
    readonly databricksSqlAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/entitlements#group_id Entitlements#group_id}
    */
    readonly groupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/entitlements#id Entitlements#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/entitlements#service_principal_id Entitlements#service_principal_id}
    */
    readonly servicePrincipalId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/entitlements#user_id Entitlements#user_id}
    */
    readonly userId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/entitlements#workspace_access Entitlements#workspace_access}
    */
    readonly workspaceAccess?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/entitlements databricks_entitlements}
*/
export declare class Entitlements extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_entitlements";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/entitlements databricks_entitlements} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EntitlementsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: EntitlementsConfig);
    private _allowClusterCreate?;
    get allowClusterCreate(): boolean | cdktf.IResolvable;
    set allowClusterCreate(value: boolean | cdktf.IResolvable);
    resetAllowClusterCreate(): void;
    get allowClusterCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _allowInstancePoolCreate?;
    get allowInstancePoolCreate(): boolean | cdktf.IResolvable;
    set allowInstancePoolCreate(value: boolean | cdktf.IResolvable);
    resetAllowInstancePoolCreate(): void;
    get allowInstancePoolCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _databricksSqlAccess?;
    get databricksSqlAccess(): boolean | cdktf.IResolvable;
    set databricksSqlAccess(value: boolean | cdktf.IResolvable);
    resetDatabricksSqlAccess(): void;
    get databricksSqlAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    resetGroupId(): void;
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _servicePrincipalId?;
    get servicePrincipalId(): string;
    set servicePrincipalId(value: string);
    resetServicePrincipalId(): void;
    get servicePrincipalIdInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    private _workspaceAccess?;
    get workspaceAccess(): boolean | cdktf.IResolvable;
    set workspaceAccess(value: boolean | cdktf.IResolvable);
    resetWorkspaceAccess(): void;
    get workspaceAccessInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
