import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GitCredentialConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/git_credential#force GitCredential#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/git_credential#git_provider GitCredential#git_provider}
    */
    readonly gitProvider: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/git_credential#git_username GitCredential#git_username}
    */
    readonly gitUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/git_credential#id GitCredential#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/git_credential#personal_access_token GitCredential#personal_access_token}
    */
    readonly personalAccessToken: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/git_credential databricks_git_credential}
*/
export declare class GitCredential extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_git_credential";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/git_credential databricks_git_credential} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GitCredentialConfig
    */
    constructor(scope: Construct, id: string, config: GitCredentialConfig);
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _gitProvider?;
    get gitProvider(): string;
    set gitProvider(value: string);
    get gitProviderInput(): string | undefined;
    private _gitUsername?;
    get gitUsername(): string;
    set gitUsername(value: string);
    get gitUsernameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _personalAccessToken?;
    get personalAccessToken(): string;
    set personalAccessToken(value: string);
    get personalAccessTokenInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
