import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#catalog Grants#catalog}
    */
    readonly catalog?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#external_location Grants#external_location}
    */
    readonly externalLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#function Grants#function}
    */
    readonly function?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#id Grants#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#metastore Grants#metastore}
    */
    readonly metastore?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#schema Grants#schema}
    */
    readonly schema?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#storage_credential Grants#storage_credential}
    */
    readonly storageCredential?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#table Grants#table}
    */
    readonly table?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#view Grants#view}
    */
    readonly view?: string;
    /**
    * grant block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#grant Grants#grant}
    */
    readonly grant: GrantsGrant[] | cdktf.IResolvable;
}
export interface GrantsGrant {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#principal Grants#principal}
    */
    readonly principal: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/grants#privileges Grants#privileges}
    */
    readonly privileges: string[];
}
export declare function grantsGrantToTerraform(struct?: GrantsGrant | cdktf.IResolvable): any;
export declare class GrantsGrantOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GrantsGrant | cdktf.IResolvable | undefined;
    set internalValue(value: GrantsGrant | cdktf.IResolvable | undefined);
    private _principal?;
    get principal(): string;
    set principal(value: string);
    get principalInput(): string | undefined;
    private _privileges?;
    get privileges(): string[];
    set privileges(value: string[]);
    get privilegesInput(): string[] | undefined;
}
export declare class GrantsGrantList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GrantsGrant[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GrantsGrantOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/grants databricks_grants}
*/
export declare class Grants extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_grants";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/grants databricks_grants} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantsConfig
    */
    constructor(scope: Construct, id: string, config: GrantsConfig);
    private _catalog?;
    get catalog(): string;
    set catalog(value: string);
    resetCatalog(): void;
    get catalogInput(): string | undefined;
    private _externalLocation?;
    get externalLocation(): string;
    set externalLocation(value: string);
    resetExternalLocation(): void;
    get externalLocationInput(): string | undefined;
    private _function?;
    get function(): string;
    set function(value: string);
    resetFunction(): void;
    get functionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metastore?;
    get metastore(): string;
    set metastore(value: string);
    resetMetastore(): void;
    get metastoreInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _storageCredential?;
    get storageCredential(): string;
    set storageCredential(value: string);
    resetStorageCredential(): void;
    get storageCredentialInput(): string | undefined;
    private _table?;
    get table(): string;
    set table(value: string);
    resetTable(): void;
    get tableInput(): string | undefined;
    private _view?;
    get view(): string;
    set view(value: string);
    resetView(): void;
    get viewInput(): string | undefined;
    private _grant;
    get grant(): GrantsGrantList;
    putGrant(value: GrantsGrant[] | cdktf.IResolvable): void;
    get grantInput(): cdktf.IResolvable | GrantsGrant[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
