import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupInstanceProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/group_instance_profile#group_id GroupInstanceProfile#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/group_instance_profile#id GroupInstanceProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/group_instance_profile#instance_profile_id GroupInstanceProfile#instance_profile_id}
    */
    readonly instanceProfileId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/group_instance_profile databricks_group_instance_profile}
*/
export declare class GroupInstanceProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_group_instance_profile";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/group_instance_profile databricks_group_instance_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupInstanceProfileConfig
    */
    constructor(scope: Construct, id: string, config: GroupInstanceProfileConfig);
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceProfileId?;
    get instanceProfileId(): string;
    set instanceProfileId(value: string);
    get instanceProfileIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
