import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/group_member#group_id GroupMember#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/group_member#id GroupMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/group_member#member_id GroupMember#member_id}
    */
    readonly memberId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/group_member databricks_group_member}
*/
export declare class GroupMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_group_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/group_member databricks_group_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupMemberConfig
    */
    constructor(scope: Construct, id: string, config: GroupMemberConfig);
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _memberId?;
    get memberId(): string;
    set memberId(value: string);
    get memberIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
