import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface InstanceProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_profile#id InstanceProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_profile#instance_profile_arn InstanceProfile#instance_profile_arn}
    */
    readonly instanceProfileArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_profile#is_meta_instance_profile InstanceProfile#is_meta_instance_profile}
    */
    readonly isMetaInstanceProfile?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/instance_profile#skip_validation InstanceProfile#skip_validation}
    */
    readonly skipValidation?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/instance_profile databricks_instance_profile}
*/
export declare class InstanceProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_instance_profile";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/instance_profile databricks_instance_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options InstanceProfileConfig = {}
    */
    constructor(scope: Construct, id: string, config?: InstanceProfileConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceProfileArn?;
    get instanceProfileArn(): string;
    set instanceProfileArn(value: string);
    resetInstanceProfileArn(): void;
    get instanceProfileArnInput(): string | undefined;
    private _isMetaInstanceProfile?;
    get isMetaInstanceProfile(): boolean | cdktf.IResolvable;
    set isMetaInstanceProfile(value: boolean | cdktf.IResolvable);
    resetIsMetaInstanceProfile(): void;
    get isMetaInstanceProfileInput(): boolean | cdktf.IResolvable | undefined;
    private _skipValidation?;
    get skipValidation(): boolean | cdktf.IResolvable;
    set skipValidation(value: boolean | cdktf.IResolvable);
    resetSkipValidation(): void;
    get skipValidationInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
