import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IpAccessListConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/ip_access_list#enabled IpAccessList#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/ip_access_list#id IpAccessList#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/ip_access_list#ip_addresses IpAccessList#ip_addresses}
    */
    readonly ipAddresses: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/ip_access_list#label IpAccessList#label}
    */
    readonly label: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/ip_access_list#list_type IpAccessList#list_type}
    */
    readonly listType: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/ip_access_list databricks_ip_access_list}
*/
export declare class IpAccessList extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_ip_access_list";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/ip_access_list databricks_ip_access_list} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IpAccessListConfig
    */
    constructor(scope: Construct, id: string, config: IpAccessListConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipAddresses?;
    get ipAddresses(): string[];
    set ipAddresses(value: string[]);
    get ipAddressesInput(): string[] | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _listType?;
    get listType(): string;
    set listType(value: string);
    get listTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
