import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LibraryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#cluster_id Library#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#egg Library#egg}
    */
    readonly egg?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#id Library#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#jar Library#jar}
    */
    readonly jar?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#whl Library#whl}
    */
    readonly whl?: string;
    /**
    * cran block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#cran Library#cran}
    */
    readonly cran?: LibraryCran;
    /**
    * maven block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#maven Library#maven}
    */
    readonly maven?: LibraryMaven;
    /**
    * pypi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#pypi Library#pypi}
    */
    readonly pypi?: LibraryPypi;
}
export interface LibraryCran {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#package Library#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#repo Library#repo}
    */
    readonly repo?: string;
}
export declare function libraryCranToTerraform(struct?: LibraryCranOutputReference | LibraryCran): any;
export declare class LibraryCranOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LibraryCran | undefined;
    set internalValue(value: LibraryCran | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface LibraryMaven {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#coordinates Library#coordinates}
    */
    readonly coordinates: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#exclusions Library#exclusions}
    */
    readonly exclusions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#repo Library#repo}
    */
    readonly repo?: string;
}
export declare function libraryMavenToTerraform(struct?: LibraryMavenOutputReference | LibraryMaven): any;
export declare class LibraryMavenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LibraryMaven | undefined;
    set internalValue(value: LibraryMaven | undefined);
    private _coordinates?;
    get coordinates(): string;
    set coordinates(value: string);
    get coordinatesInput(): string | undefined;
    private _exclusions?;
    get exclusions(): string[];
    set exclusions(value: string[]);
    resetExclusions(): void;
    get exclusionsInput(): string[] | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
export interface LibraryPypi {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#package Library#package}
    */
    readonly package: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/library#repo Library#repo}
    */
    readonly repo?: string;
}
export declare function libraryPypiToTerraform(struct?: LibraryPypiOutputReference | LibraryPypi): any;
export declare class LibraryPypiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LibraryPypi | undefined;
    set internalValue(value: LibraryPypi | undefined);
    private _package?;
    get package(): string;
    set package(value: string);
    get packageInput(): string | undefined;
    private _repo?;
    get repo(): string;
    set repo(value: string);
    resetRepo(): void;
    get repoInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/library databricks_library}
*/
export declare class Library extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_library";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/library databricks_library} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LibraryConfig
    */
    constructor(scope: Construct, id: string, config: LibraryConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _egg?;
    get egg(): string;
    set egg(value: string);
    resetEgg(): void;
    get eggInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jar?;
    get jar(): string;
    set jar(value: string);
    resetJar(): void;
    get jarInput(): string | undefined;
    private _whl?;
    get whl(): string;
    set whl(value: string);
    resetWhl(): void;
    get whlInput(): string | undefined;
    private _cran;
    get cran(): LibraryCranOutputReference;
    putCran(value: LibraryCran): void;
    resetCran(): void;
    get cranInput(): LibraryCran | undefined;
    private _maven;
    get maven(): LibraryMavenOutputReference;
    putMaven(value: LibraryMaven): void;
    resetMaven(): void;
    get mavenInput(): LibraryMaven | undefined;
    private _pypi;
    get pypi(): LibraryPypiOutputReference;
    putPypi(value: LibraryPypi): void;
    resetPypi(): void;
    get pypiInput(): LibraryPypi | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
