import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MetastoreAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_assignment#default_catalog_name MetastoreAssignment#default_catalog_name}
    */
    readonly defaultCatalogName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_assignment#id MetastoreAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_assignment#metastore_id MetastoreAssignment#metastore_id}
    */
    readonly metastoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore_assignment#workspace_id MetastoreAssignment#workspace_id}
    */
    readonly workspaceId: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/metastore_assignment databricks_metastore_assignment}
*/
export declare class MetastoreAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_metastore_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/metastore_assignment databricks_metastore_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MetastoreAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: MetastoreAssignmentConfig);
    private _defaultCatalogName?;
    get defaultCatalogName(): string;
    set defaultCatalogName(value: string);
    resetDefaultCatalogName(): void;
    get defaultCatalogNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metastoreId?;
    get metastoreId(): string;
    set metastoreId(value: string);
    get metastoreIdInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): number;
    set workspaceId(value: number);
    get workspaceIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
