import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MetastoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#cloud Metastore#cloud}
    */
    readonly cloud?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#created_at Metastore#created_at}
    */
    readonly createdAt?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#created_by Metastore#created_by}
    */
    readonly createdBy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#default_data_access_config_id Metastore#default_data_access_config_id}
    */
    readonly defaultDataAccessConfigId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#delta_sharing_organization_name Metastore#delta_sharing_organization_name}
    */
    readonly deltaSharingOrganizationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#delta_sharing_recipient_token_lifetime_in_seconds Metastore#delta_sharing_recipient_token_lifetime_in_seconds}
    */
    readonly deltaSharingRecipientTokenLifetimeInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#delta_sharing_scope Metastore#delta_sharing_scope}
    */
    readonly deltaSharingScope?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#force_destroy Metastore#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#global_metastore_id Metastore#global_metastore_id}
    */
    readonly globalMetastoreId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#id Metastore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#name Metastore#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#owner Metastore#owner}
    */
    readonly owner?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#region Metastore#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#storage_root Metastore#storage_root}
    */
    readonly storageRoot: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#updated_at Metastore#updated_at}
    */
    readonly updatedAt?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/metastore#updated_by Metastore#updated_by}
    */
    readonly updatedBy?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/metastore databricks_metastore}
*/
export declare class Metastore extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_metastore";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/metastore databricks_metastore} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MetastoreConfig
    */
    constructor(scope: Construct, id: string, config: MetastoreConfig);
    private _cloud?;
    get cloud(): string;
    set cloud(value: string);
    resetCloud(): void;
    get cloudInput(): string | undefined;
    private _createdAt?;
    get createdAt(): number;
    set createdAt(value: number);
    resetCreatedAt(): void;
    get createdAtInput(): number | undefined;
    private _createdBy?;
    get createdBy(): string;
    set createdBy(value: string);
    resetCreatedBy(): void;
    get createdByInput(): string | undefined;
    private _defaultDataAccessConfigId?;
    get defaultDataAccessConfigId(): string;
    set defaultDataAccessConfigId(value: string);
    resetDefaultDataAccessConfigId(): void;
    get defaultDataAccessConfigIdInput(): string | undefined;
    private _deltaSharingOrganizationName?;
    get deltaSharingOrganizationName(): string;
    set deltaSharingOrganizationName(value: string);
    resetDeltaSharingOrganizationName(): void;
    get deltaSharingOrganizationNameInput(): string | undefined;
    private _deltaSharingRecipientTokenLifetimeInSeconds?;
    get deltaSharingRecipientTokenLifetimeInSeconds(): number;
    set deltaSharingRecipientTokenLifetimeInSeconds(value: number);
    resetDeltaSharingRecipientTokenLifetimeInSeconds(): void;
    get deltaSharingRecipientTokenLifetimeInSecondsInput(): number | undefined;
    private _deltaSharingScope?;
    get deltaSharingScope(): string;
    set deltaSharingScope(value: string);
    resetDeltaSharingScope(): void;
    get deltaSharingScopeInput(): string | undefined;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _globalMetastoreId?;
    get globalMetastoreId(): string;
    set globalMetastoreId(value: string);
    resetGlobalMetastoreId(): void;
    get globalMetastoreIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _owner?;
    get owner(): string;
    set owner(value: string);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _storageRoot?;
    get storageRoot(): string;
    set storageRoot(value: string);
    get storageRootInput(): string | undefined;
    private _updatedAt?;
    get updatedAt(): number;
    set updatedAt(value: number);
    resetUpdatedAt(): void;
    get updatedAtInput(): number | undefined;
    private _updatedBy?;
    get updatedBy(): string;
    set updatedBy(value: string);
    resetUpdatedBy(): void;
    get updatedByInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
