import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MlflowWebhookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#description MlflowWebhook#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#events MlflowWebhook#events}
    */
    readonly events: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#id MlflowWebhook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#model_name MlflowWebhook#model_name}
    */
    readonly modelName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#status MlflowWebhook#status}
    */
    readonly status?: string;
    /**
    * http_url_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#http_url_spec MlflowWebhook#http_url_spec}
    */
    readonly httpUrlSpec?: MlflowWebhookHttpUrlSpec;
    /**
    * job_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#job_spec MlflowWebhook#job_spec}
    */
    readonly jobSpec?: MlflowWebhookJobSpec;
}
export interface MlflowWebhookHttpUrlSpec {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#authorization MlflowWebhook#authorization}
    */
    readonly authorization?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#enable_ssl_verification MlflowWebhook#enable_ssl_verification}
    */
    readonly enableSslVerification?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#secret MlflowWebhook#secret}
    */
    readonly secret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#url MlflowWebhook#url}
    */
    readonly url: string;
}
export declare function mlflowWebhookHttpUrlSpecToTerraform(struct?: MlflowWebhookHttpUrlSpecOutputReference | MlflowWebhookHttpUrlSpec): any;
export declare class MlflowWebhookHttpUrlSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MlflowWebhookHttpUrlSpec | undefined;
    set internalValue(value: MlflowWebhookHttpUrlSpec | undefined);
    private _authorization?;
    get authorization(): string;
    set authorization(value: string);
    resetAuthorization(): void;
    get authorizationInput(): string | undefined;
    private _enableSslVerification?;
    get enableSslVerification(): boolean | cdktf.IResolvable;
    set enableSslVerification(value: boolean | cdktf.IResolvable);
    resetEnableSslVerification(): void;
    get enableSslVerificationInput(): boolean | cdktf.IResolvable | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    resetSecret(): void;
    get secretInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface MlflowWebhookJobSpec {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#access_token MlflowWebhook#access_token}
    */
    readonly accessToken: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#job_id MlflowWebhook#job_id}
    */
    readonly jobId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook#workspace_url MlflowWebhook#workspace_url}
    */
    readonly workspaceUrl?: string;
}
export declare function mlflowWebhookJobSpecToTerraform(struct?: MlflowWebhookJobSpecOutputReference | MlflowWebhookJobSpec): any;
export declare class MlflowWebhookJobSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MlflowWebhookJobSpec | undefined;
    set internalValue(value: MlflowWebhookJobSpec | undefined);
    private _accessToken?;
    get accessToken(): string;
    set accessToken(value: string);
    get accessTokenInput(): string | undefined;
    private _jobId?;
    get jobId(): string;
    set jobId(value: string);
    get jobIdInput(): string | undefined;
    private _workspaceUrl?;
    get workspaceUrl(): string;
    set workspaceUrl(value: string);
    resetWorkspaceUrl(): void;
    get workspaceUrlInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook databricks_mlflow_webhook}
*/
export declare class MlflowWebhook extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mlflow_webhook";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mlflow_webhook databricks_mlflow_webhook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MlflowWebhookConfig
    */
    constructor(scope: Construct, id: string, config: MlflowWebhookConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _events?;
    get events(): string[];
    set events(value: string[]);
    get eventsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _modelName?;
    get modelName(): string;
    set modelName(value: string);
    resetModelName(): void;
    get modelNameInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _httpUrlSpec;
    get httpUrlSpec(): MlflowWebhookHttpUrlSpecOutputReference;
    putHttpUrlSpec(value: MlflowWebhookHttpUrlSpec): void;
    resetHttpUrlSpec(): void;
    get httpUrlSpecInput(): MlflowWebhookHttpUrlSpec | undefined;
    private _jobSpec;
    get jobSpec(): MlflowWebhookJobSpecOutputReference;
    putJobSpec(value: MlflowWebhookJobSpec): void;
    resetJobSpec(): void;
    get jobSpecInput(): MlflowWebhookJobSpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
