import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#cluster_id Mount#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#encryption_type Mount#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#extra_configs Mount#extra_configs}
    */
    readonly extraConfigs?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#id Mount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#name Mount#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#resource_id Mount#resource_id}
    */
    readonly resourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#uri Mount#uri}
    */
    readonly uri?: string;
    /**
    * abfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#abfs Mount#abfs}
    */
    readonly abfs?: MountAbfs;
    /**
    * adl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#adl Mount#adl}
    */
    readonly adl?: MountAdl;
    /**
    * gs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#gs Mount#gs}
    */
    readonly gs?: MountGs;
    /**
    * s3 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#s3 Mount#s3}
    */
    readonly s3?: MountS3;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#timeouts Mount#timeouts}
    */
    readonly timeouts?: MountTimeouts;
    /**
    * wasb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#wasb Mount#wasb}
    */
    readonly wasb?: MountWasb;
}
export interface MountAbfs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#client_id Mount#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#client_secret_key Mount#client_secret_key}
    */
    readonly clientSecretKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#client_secret_scope Mount#client_secret_scope}
    */
    readonly clientSecretScope: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#container_name Mount#container_name}
    */
    readonly containerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#directory Mount#directory}
    */
    readonly directory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#initialize_file_system Mount#initialize_file_system}
    */
    readonly initializeFileSystem: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#storage_account_name Mount#storage_account_name}
    */
    readonly storageAccountName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#tenant_id Mount#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function mountAbfsToTerraform(struct?: MountAbfsOutputReference | MountAbfs): any;
export declare class MountAbfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MountAbfs | undefined;
    set internalValue(value: MountAbfs | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretKey?;
    get clientSecretKey(): string;
    set clientSecretKey(value: string);
    get clientSecretKeyInput(): string | undefined;
    private _clientSecretScope?;
    get clientSecretScope(): string;
    set clientSecretScope(value: string);
    get clientSecretScopeInput(): string | undefined;
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    resetContainerName(): void;
    get containerNameInput(): string | undefined;
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _initializeFileSystem?;
    get initializeFileSystem(): boolean | cdktf.IResolvable;
    set initializeFileSystem(value: boolean | cdktf.IResolvable);
    get initializeFileSystemInput(): boolean | cdktf.IResolvable | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    resetStorageAccountName(): void;
    get storageAccountNameInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export interface MountAdl {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#client_id Mount#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#client_secret_key Mount#client_secret_key}
    */
    readonly clientSecretKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#client_secret_scope Mount#client_secret_scope}
    */
    readonly clientSecretScope: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#directory Mount#directory}
    */
    readonly directory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#spark_conf_prefix Mount#spark_conf_prefix}
    */
    readonly sparkConfPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#storage_resource_name Mount#storage_resource_name}
    */
    readonly storageResourceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#tenant_id Mount#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function mountAdlToTerraform(struct?: MountAdlOutputReference | MountAdl): any;
export declare class MountAdlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MountAdl | undefined;
    set internalValue(value: MountAdl | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretKey?;
    get clientSecretKey(): string;
    set clientSecretKey(value: string);
    get clientSecretKeyInput(): string | undefined;
    private _clientSecretScope?;
    get clientSecretScope(): string;
    set clientSecretScope(value: string);
    get clientSecretScopeInput(): string | undefined;
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _sparkConfPrefix?;
    get sparkConfPrefix(): string;
    set sparkConfPrefix(value: string);
    resetSparkConfPrefix(): void;
    get sparkConfPrefixInput(): string | undefined;
    private _storageResourceName?;
    get storageResourceName(): string;
    set storageResourceName(value: string);
    resetStorageResourceName(): void;
    get storageResourceNameInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export interface MountGs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#bucket_name Mount#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#service_account Mount#service_account}
    */
    readonly serviceAccount?: string;
}
export declare function mountGsToTerraform(struct?: MountGsOutputReference | MountGs): any;
export declare class MountGsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MountGs | undefined;
    set internalValue(value: MountGs | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
}
export interface MountS3 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#bucket_name Mount#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#instance_profile Mount#instance_profile}
    */
    readonly instanceProfile?: string;
}
export declare function mountS3ToTerraform(struct?: MountS3OutputReference | MountS3): any;
export declare class MountS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MountS3 | undefined;
    set internalValue(value: MountS3 | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _instanceProfile?;
    get instanceProfile(): string;
    set instanceProfile(value: string);
    resetInstanceProfile(): void;
    get instanceProfileInput(): string | undefined;
}
export interface MountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#default Mount#default}
    */
    readonly default?: string;
}
export declare function mountTimeoutsToTerraform(struct?: MountTimeoutsOutputReference | MountTimeouts | cdktf.IResolvable): any;
export declare class MountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MountTimeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
export interface MountWasb {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#auth_type Mount#auth_type}
    */
    readonly authType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#container_name Mount#container_name}
    */
    readonly containerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#directory Mount#directory}
    */
    readonly directory?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#storage_account_name Mount#storage_account_name}
    */
    readonly storageAccountName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#token_secret_key Mount#token_secret_key}
    */
    readonly tokenSecretKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mount#token_secret_scope Mount#token_secret_scope}
    */
    readonly tokenSecretScope: string;
}
export declare function mountWasbToTerraform(struct?: MountWasbOutputReference | MountWasb): any;
export declare class MountWasbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MountWasb | undefined;
    set internalValue(value: MountWasb | undefined);
    private _authType?;
    get authType(): string;
    set authType(value: string);
    get authTypeInput(): string | undefined;
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    resetContainerName(): void;
    get containerNameInput(): string | undefined;
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    resetStorageAccountName(): void;
    get storageAccountNameInput(): string | undefined;
    private _tokenSecretKey?;
    get tokenSecretKey(): string;
    set tokenSecretKey(value: string);
    get tokenSecretKeyInput(): string | undefined;
    private _tokenSecretScope?;
    get tokenSecretScope(): string;
    set tokenSecretScope(value: string);
    get tokenSecretScopeInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mount databricks_mount}
*/
export declare class Mount extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mount";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mount databricks_mount} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MountConfig = {}
    */
    constructor(scope: Construct, id: string, config?: MountConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _extraConfigs?;
    get extraConfigs(): {
        [key: string]: string;
    };
    set extraConfigs(value: {
        [key: string]: string;
    });
    resetExtraConfigs(): void;
    get extraConfigsInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    resetResourceId(): void;
    get resourceIdInput(): string | undefined;
    get source(): string;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    resetUri(): void;
    get uriInput(): string | undefined;
    private _abfs;
    get abfs(): MountAbfsOutputReference;
    putAbfs(value: MountAbfs): void;
    resetAbfs(): void;
    get abfsInput(): MountAbfs | undefined;
    private _adl;
    get adl(): MountAdlOutputReference;
    putAdl(value: MountAdl): void;
    resetAdl(): void;
    get adlInput(): MountAdl | undefined;
    private _gs;
    get gs(): MountGsOutputReference;
    putGs(value: MountGs): void;
    resetGs(): void;
    get gsInput(): MountGs | undefined;
    private _s3;
    get s3(): MountS3OutputReference;
    putS3(value: MountS3): void;
    resetS3(): void;
    get s3Input(): MountS3 | undefined;
    private _timeouts;
    get timeouts(): MountTimeoutsOutputReference;
    putTimeouts(value: MountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MountTimeouts | undefined;
    private _wasb;
    get wasb(): MountWasbOutputReference;
    putWasb(value: MountWasb): void;
    resetWasb(): void;
    get wasbInput(): MountWasb | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
