import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MwsCredentialsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_credentials#account_id MwsCredentials#account_id}
    */
    readonly accountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_credentials#credentials_name MwsCredentials#credentials_name}
    */
    readonly credentialsName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_credentials#id MwsCredentials#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_credentials#role_arn MwsCredentials#role_arn}
    */
    readonly roleArn: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mws_credentials databricks_mws_credentials}
*/
export declare class MwsCredentials extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mws_credentials";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mws_credentials databricks_mws_credentials} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MwsCredentialsConfig
    */
    constructor(scope: Construct, id: string, config: MwsCredentialsConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    get creationTime(): number;
    get credentialsId(): string;
    private _credentialsName?;
    get credentialsName(): string;
    set credentialsName(value: string);
    get credentialsNameInput(): string | undefined;
    get externalId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
