import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MwsLogDeliveryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#account_id MwsLogDelivery#account_id}
    */
    readonly accountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#config_id MwsLogDelivery#config_id}
    */
    readonly configId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#config_name MwsLogDelivery#config_name}
    */
    readonly configName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#credentials_id MwsLogDelivery#credentials_id}
    */
    readonly credentialsId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#delivery_path_prefix MwsLogDelivery#delivery_path_prefix}
    */
    readonly deliveryPathPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#delivery_start_time MwsLogDelivery#delivery_start_time}
    */
    readonly deliveryStartTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#id MwsLogDelivery#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#log_type MwsLogDelivery#log_type}
    */
    readonly logType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#output_format MwsLogDelivery#output_format}
    */
    readonly outputFormat: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#status MwsLogDelivery#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#storage_configuration_id MwsLogDelivery#storage_configuration_id}
    */
    readonly storageConfigurationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery#workspace_ids_filter MwsLogDelivery#workspace_ids_filter}
    */
    readonly workspaceIdsFilter?: number[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery databricks_mws_log_delivery}
*/
export declare class MwsLogDelivery extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mws_log_delivery";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mws_log_delivery databricks_mws_log_delivery} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MwsLogDeliveryConfig
    */
    constructor(scope: Construct, id: string, config: MwsLogDeliveryConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _configId?;
    get configId(): string;
    set configId(value: string);
    resetConfigId(): void;
    get configIdInput(): string | undefined;
    private _configName?;
    get configName(): string;
    set configName(value: string);
    resetConfigName(): void;
    get configNameInput(): string | undefined;
    private _credentialsId?;
    get credentialsId(): string;
    set credentialsId(value: string);
    get credentialsIdInput(): string | undefined;
    private _deliveryPathPrefix?;
    get deliveryPathPrefix(): string;
    set deliveryPathPrefix(value: string);
    resetDeliveryPathPrefix(): void;
    get deliveryPathPrefixInput(): string | undefined;
    private _deliveryStartTime?;
    get deliveryStartTime(): string;
    set deliveryStartTime(value: string);
    resetDeliveryStartTime(): void;
    get deliveryStartTimeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logType?;
    get logType(): string;
    set logType(value: string);
    get logTypeInput(): string | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    get outputFormatInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _storageConfigurationId?;
    get storageConfigurationId(): string;
    set storageConfigurationId(value: string);
    get storageConfigurationIdInput(): string | undefined;
    private _workspaceIdsFilter?;
    get workspaceIdsFilter(): number[];
    set workspaceIdsFilter(value: number[]);
    resetWorkspaceIdsFilter(): void;
    get workspaceIdsFilterInput(): number[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
