import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MwsWorkspacesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#account_id MwsWorkspaces#account_id}
    */
    readonly accountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#aws_region MwsWorkspaces#aws_region}
    */
    readonly awsRegion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#cloud MwsWorkspaces#cloud}
    */
    readonly cloud?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#creation_time MwsWorkspaces#creation_time}
    */
    readonly creationTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#credentials_id MwsWorkspaces#credentials_id}
    */
    readonly credentialsId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#customer_managed_key_id MwsWorkspaces#customer_managed_key_id}
    */
    readonly customerManagedKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#deployment_name MwsWorkspaces#deployment_name}
    */
    readonly deploymentName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#id MwsWorkspaces#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#is_no_public_ip_enabled MwsWorkspaces#is_no_public_ip_enabled}
    */
    readonly isNoPublicIpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#location MwsWorkspaces#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#managed_services_customer_managed_key_id MwsWorkspaces#managed_services_customer_managed_key_id}
    */
    readonly managedServicesCustomerManagedKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#network_id MwsWorkspaces#network_id}
    */
    readonly networkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#pricing_tier MwsWorkspaces#pricing_tier}
    */
    readonly pricingTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#private_access_settings_id MwsWorkspaces#private_access_settings_id}
    */
    readonly privateAccessSettingsId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#storage_configuration_id MwsWorkspaces#storage_configuration_id}
    */
    readonly storageConfigurationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#storage_customer_managed_key_id MwsWorkspaces#storage_customer_managed_key_id}
    */
    readonly storageCustomerManagedKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#workspace_id MwsWorkspaces#workspace_id}
    */
    readonly workspaceId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#workspace_name MwsWorkspaces#workspace_name}
    */
    readonly workspaceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#workspace_status MwsWorkspaces#workspace_status}
    */
    readonly workspaceStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#workspace_status_message MwsWorkspaces#workspace_status_message}
    */
    readonly workspaceStatusMessage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#workspace_url MwsWorkspaces#workspace_url}
    */
    readonly workspaceUrl?: string;
    /**
    * cloud_resource_bucket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#cloud_resource_bucket MwsWorkspaces#cloud_resource_bucket}
    */
    readonly cloudResourceBucket?: MwsWorkspacesCloudResourceBucket;
    /**
    * external_customer_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#external_customer_info MwsWorkspaces#external_customer_info}
    */
    readonly externalCustomerInfo?: MwsWorkspacesExternalCustomerInfo;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#network MwsWorkspaces#network}
    */
    readonly network?: MwsWorkspacesNetwork;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#timeouts MwsWorkspaces#timeouts}
    */
    readonly timeouts?: MwsWorkspacesTimeouts;
    /**
    * token block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#token MwsWorkspaces#token}
    */
    readonly token?: MwsWorkspacesToken;
}
export interface MwsWorkspacesCloudResourceBucketGcp {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#project_id MwsWorkspaces#project_id}
    */
    readonly projectId: string;
}
export declare function mwsWorkspacesCloudResourceBucketGcpToTerraform(struct?: MwsWorkspacesCloudResourceBucketGcpOutputReference | MwsWorkspacesCloudResourceBucketGcp): any;
export declare class MwsWorkspacesCloudResourceBucketGcpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsWorkspacesCloudResourceBucketGcp | undefined;
    set internalValue(value: MwsWorkspacesCloudResourceBucketGcp | undefined);
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
}
export interface MwsWorkspacesCloudResourceBucket {
    /**
    * gcp block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#gcp MwsWorkspaces#gcp}
    */
    readonly gcp: MwsWorkspacesCloudResourceBucketGcp;
}
export declare function mwsWorkspacesCloudResourceBucketToTerraform(struct?: MwsWorkspacesCloudResourceBucketOutputReference | MwsWorkspacesCloudResourceBucket): any;
export declare class MwsWorkspacesCloudResourceBucketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsWorkspacesCloudResourceBucket | undefined;
    set internalValue(value: MwsWorkspacesCloudResourceBucket | undefined);
    private _gcp;
    get gcp(): MwsWorkspacesCloudResourceBucketGcpOutputReference;
    putGcp(value: MwsWorkspacesCloudResourceBucketGcp): void;
    get gcpInput(): MwsWorkspacesCloudResourceBucketGcp | undefined;
}
export interface MwsWorkspacesExternalCustomerInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#authoritative_user_email MwsWorkspaces#authoritative_user_email}
    */
    readonly authoritativeUserEmail: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#authoritative_user_full_name MwsWorkspaces#authoritative_user_full_name}
    */
    readonly authoritativeUserFullName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#customer_name MwsWorkspaces#customer_name}
    */
    readonly customerName: string;
}
export declare function mwsWorkspacesExternalCustomerInfoToTerraform(struct?: MwsWorkspacesExternalCustomerInfoOutputReference | MwsWorkspacesExternalCustomerInfo): any;
export declare class MwsWorkspacesExternalCustomerInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsWorkspacesExternalCustomerInfo | undefined;
    set internalValue(value: MwsWorkspacesExternalCustomerInfo | undefined);
    private _authoritativeUserEmail?;
    get authoritativeUserEmail(): string;
    set authoritativeUserEmail(value: string);
    get authoritativeUserEmailInput(): string | undefined;
    private _authoritativeUserFullName?;
    get authoritativeUserFullName(): string;
    set authoritativeUserFullName(value: string);
    get authoritativeUserFullNameInput(): string | undefined;
    private _customerName?;
    get customerName(): string;
    set customerName(value: string);
    get customerNameInput(): string | undefined;
}
export interface MwsWorkspacesNetworkGcpCommonNetworkConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#gke_cluster_master_ip_range MwsWorkspaces#gke_cluster_master_ip_range}
    */
    readonly gkeClusterMasterIpRange: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#gke_connectivity_type MwsWorkspaces#gke_connectivity_type}
    */
    readonly gkeConnectivityType: string;
}
export declare function mwsWorkspacesNetworkGcpCommonNetworkConfigToTerraform(struct?: MwsWorkspacesNetworkGcpCommonNetworkConfigOutputReference | MwsWorkspacesNetworkGcpCommonNetworkConfig): any;
export declare class MwsWorkspacesNetworkGcpCommonNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsWorkspacesNetworkGcpCommonNetworkConfig | undefined;
    set internalValue(value: MwsWorkspacesNetworkGcpCommonNetworkConfig | undefined);
    private _gkeClusterMasterIpRange?;
    get gkeClusterMasterIpRange(): string;
    set gkeClusterMasterIpRange(value: string);
    get gkeClusterMasterIpRangeInput(): string | undefined;
    private _gkeConnectivityType?;
    get gkeConnectivityType(): string;
    set gkeConnectivityType(value: string);
    get gkeConnectivityTypeInput(): string | undefined;
}
export interface MwsWorkspacesNetworkGcpManagedNetworkConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#gke_cluster_pod_ip_range MwsWorkspaces#gke_cluster_pod_ip_range}
    */
    readonly gkeClusterPodIpRange: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#gke_cluster_service_ip_range MwsWorkspaces#gke_cluster_service_ip_range}
    */
    readonly gkeClusterServiceIpRange: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#subnet_cidr MwsWorkspaces#subnet_cidr}
    */
    readonly subnetCidr: string;
}
export declare function mwsWorkspacesNetworkGcpManagedNetworkConfigToTerraform(struct?: MwsWorkspacesNetworkGcpManagedNetworkConfigOutputReference | MwsWorkspacesNetworkGcpManagedNetworkConfig): any;
export declare class MwsWorkspacesNetworkGcpManagedNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsWorkspacesNetworkGcpManagedNetworkConfig | undefined;
    set internalValue(value: MwsWorkspacesNetworkGcpManagedNetworkConfig | undefined);
    private _gkeClusterPodIpRange?;
    get gkeClusterPodIpRange(): string;
    set gkeClusterPodIpRange(value: string);
    get gkeClusterPodIpRangeInput(): string | undefined;
    private _gkeClusterServiceIpRange?;
    get gkeClusterServiceIpRange(): string;
    set gkeClusterServiceIpRange(value: string);
    get gkeClusterServiceIpRangeInput(): string | undefined;
    private _subnetCidr?;
    get subnetCidr(): string;
    set subnetCidr(value: string);
    get subnetCidrInput(): string | undefined;
}
export interface MwsWorkspacesNetwork {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#network_id MwsWorkspaces#network_id}
    */
    readonly networkId?: string;
    /**
    * gcp_common_network_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#gcp_common_network_config MwsWorkspaces#gcp_common_network_config}
    */
    readonly gcpCommonNetworkConfig: MwsWorkspacesNetworkGcpCommonNetworkConfig;
    /**
    * gcp_managed_network_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#gcp_managed_network_config MwsWorkspaces#gcp_managed_network_config}
    */
    readonly gcpManagedNetworkConfig?: MwsWorkspacesNetworkGcpManagedNetworkConfig;
}
export declare function mwsWorkspacesNetworkToTerraform(struct?: MwsWorkspacesNetworkOutputReference | MwsWorkspacesNetwork): any;
export declare class MwsWorkspacesNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsWorkspacesNetwork | undefined;
    set internalValue(value: MwsWorkspacesNetwork | undefined);
    private _networkId?;
    get networkId(): string;
    set networkId(value: string);
    resetNetworkId(): void;
    get networkIdInput(): string | undefined;
    private _gcpCommonNetworkConfig;
    get gcpCommonNetworkConfig(): MwsWorkspacesNetworkGcpCommonNetworkConfigOutputReference;
    putGcpCommonNetworkConfig(value: MwsWorkspacesNetworkGcpCommonNetworkConfig): void;
    get gcpCommonNetworkConfigInput(): MwsWorkspacesNetworkGcpCommonNetworkConfig | undefined;
    private _gcpManagedNetworkConfig;
    get gcpManagedNetworkConfig(): MwsWorkspacesNetworkGcpManagedNetworkConfigOutputReference;
    putGcpManagedNetworkConfig(value: MwsWorkspacesNetworkGcpManagedNetworkConfig): void;
    resetGcpManagedNetworkConfig(): void;
    get gcpManagedNetworkConfigInput(): MwsWorkspacesNetworkGcpManagedNetworkConfig | undefined;
}
export interface MwsWorkspacesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#create MwsWorkspaces#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#read MwsWorkspaces#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#update MwsWorkspaces#update}
    */
    readonly update?: string;
}
export declare function mwsWorkspacesTimeoutsToTerraform(struct?: MwsWorkspacesTimeoutsOutputReference | MwsWorkspacesTimeouts | cdktf.IResolvable): any;
export declare class MwsWorkspacesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsWorkspacesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MwsWorkspacesTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface MwsWorkspacesToken {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#comment MwsWorkspaces#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#lifetime_seconds MwsWorkspaces#lifetime_seconds}
    */
    readonly lifetimeSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#token_id MwsWorkspaces#token_id}
    */
    readonly tokenId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces#token_value MwsWorkspaces#token_value}
    */
    readonly tokenValue?: string;
}
export declare function mwsWorkspacesTokenToTerraform(struct?: MwsWorkspacesTokenOutputReference | MwsWorkspacesToken): any;
export declare class MwsWorkspacesTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MwsWorkspacesToken | undefined;
    set internalValue(value: MwsWorkspacesToken | undefined);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _lifetimeSeconds?;
    get lifetimeSeconds(): number;
    set lifetimeSeconds(value: number);
    resetLifetimeSeconds(): void;
    get lifetimeSecondsInput(): number | undefined;
    private _tokenId?;
    get tokenId(): string;
    set tokenId(value: string);
    resetTokenId(): void;
    get tokenIdInput(): string | undefined;
    private _tokenValue?;
    get tokenValue(): string;
    set tokenValue(value: string);
    resetTokenValue(): void;
    get tokenValueInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces databricks_mws_workspaces}
*/
export declare class MwsWorkspaces extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_mws_workspaces";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces databricks_mws_workspaces} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MwsWorkspacesConfig
    */
    constructor(scope: Construct, id: string, config: MwsWorkspacesConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    private _awsRegion?;
    get awsRegion(): string;
    set awsRegion(value: string);
    resetAwsRegion(): void;
    get awsRegionInput(): string | undefined;
    private _cloud?;
    get cloud(): string;
    set cloud(value: string);
    resetCloud(): void;
    get cloudInput(): string | undefined;
    private _creationTime?;
    get creationTime(): number;
    set creationTime(value: number);
    resetCreationTime(): void;
    get creationTimeInput(): number | undefined;
    private _credentialsId?;
    get credentialsId(): string;
    set credentialsId(value: string);
    resetCredentialsId(): void;
    get credentialsIdInput(): string | undefined;
    private _customerManagedKeyId?;
    get customerManagedKeyId(): string;
    set customerManagedKeyId(value: string);
    resetCustomerManagedKeyId(): void;
    get customerManagedKeyIdInput(): string | undefined;
    private _deploymentName?;
    get deploymentName(): string;
    set deploymentName(value: string);
    resetDeploymentName(): void;
    get deploymentNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isNoPublicIpEnabled?;
    get isNoPublicIpEnabled(): boolean | cdktf.IResolvable;
    set isNoPublicIpEnabled(value: boolean | cdktf.IResolvable);
    resetIsNoPublicIpEnabled(): void;
    get isNoPublicIpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _managedServicesCustomerManagedKeyId?;
    get managedServicesCustomerManagedKeyId(): string;
    set managedServicesCustomerManagedKeyId(value: string);
    resetManagedServicesCustomerManagedKeyId(): void;
    get managedServicesCustomerManagedKeyIdInput(): string | undefined;
    private _networkId?;
    get networkId(): string;
    set networkId(value: string);
    resetNetworkId(): void;
    get networkIdInput(): string | undefined;
    private _pricingTier?;
    get pricingTier(): string;
    set pricingTier(value: string);
    resetPricingTier(): void;
    get pricingTierInput(): string | undefined;
    private _privateAccessSettingsId?;
    get privateAccessSettingsId(): string;
    set privateAccessSettingsId(value: string);
    resetPrivateAccessSettingsId(): void;
    get privateAccessSettingsIdInput(): string | undefined;
    private _storageConfigurationId?;
    get storageConfigurationId(): string;
    set storageConfigurationId(value: string);
    resetStorageConfigurationId(): void;
    get storageConfigurationIdInput(): string | undefined;
    private _storageCustomerManagedKeyId?;
    get storageCustomerManagedKeyId(): string;
    set storageCustomerManagedKeyId(value: string);
    resetStorageCustomerManagedKeyId(): void;
    get storageCustomerManagedKeyIdInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): number;
    set workspaceId(value: number);
    resetWorkspaceId(): void;
    get workspaceIdInput(): number | undefined;
    private _workspaceName?;
    get workspaceName(): string;
    set workspaceName(value: string);
    get workspaceNameInput(): string | undefined;
    private _workspaceStatus?;
    get workspaceStatus(): string;
    set workspaceStatus(value: string);
    resetWorkspaceStatus(): void;
    get workspaceStatusInput(): string | undefined;
    private _workspaceStatusMessage?;
    get workspaceStatusMessage(): string;
    set workspaceStatusMessage(value: string);
    resetWorkspaceStatusMessage(): void;
    get workspaceStatusMessageInput(): string | undefined;
    private _workspaceUrl?;
    get workspaceUrl(): string;
    set workspaceUrl(value: string);
    resetWorkspaceUrl(): void;
    get workspaceUrlInput(): string | undefined;
    private _cloudResourceBucket;
    get cloudResourceBucket(): MwsWorkspacesCloudResourceBucketOutputReference;
    putCloudResourceBucket(value: MwsWorkspacesCloudResourceBucket): void;
    resetCloudResourceBucket(): void;
    get cloudResourceBucketInput(): MwsWorkspacesCloudResourceBucket | undefined;
    private _externalCustomerInfo;
    get externalCustomerInfo(): MwsWorkspacesExternalCustomerInfoOutputReference;
    putExternalCustomerInfo(value: MwsWorkspacesExternalCustomerInfo): void;
    resetExternalCustomerInfo(): void;
    get externalCustomerInfoInput(): MwsWorkspacesExternalCustomerInfo | undefined;
    private _network;
    get network(): MwsWorkspacesNetworkOutputReference;
    putNetwork(value: MwsWorkspacesNetwork): void;
    resetNetwork(): void;
    get networkInput(): MwsWorkspacesNetwork | undefined;
    private _timeouts;
    get timeouts(): MwsWorkspacesTimeoutsOutputReference;
    putTimeouts(value: MwsWorkspacesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MwsWorkspacesTimeouts | undefined;
    private _token;
    get token(): MwsWorkspacesTokenOutputReference;
    putToken(value: MwsWorkspacesToken): void;
    resetToken(): void;
    get tokenInput(): MwsWorkspacesToken | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
