"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MwsWorkspaces = exports.MwsWorkspacesTokenOutputReference = exports.mwsWorkspacesTokenToTerraform = exports.MwsWorkspacesTimeoutsOutputReference = exports.mwsWorkspacesTimeoutsToTerraform = exports.MwsWorkspacesNetworkOutputReference = exports.mwsWorkspacesNetworkToTerraform = exports.MwsWorkspacesNetworkGcpManagedNetworkConfigOutputReference = exports.mwsWorkspacesNetworkGcpManagedNetworkConfigToTerraform = exports.MwsWorkspacesNetworkGcpCommonNetworkConfigOutputReference = exports.mwsWorkspacesNetworkGcpCommonNetworkConfigToTerraform = exports.MwsWorkspacesExternalCustomerInfoOutputReference = exports.mwsWorkspacesExternalCustomerInfoToTerraform = exports.MwsWorkspacesCloudResourceBucketOutputReference = exports.mwsWorkspacesCloudResourceBucketToTerraform = exports.MwsWorkspacesCloudResourceBucketGcpOutputReference = exports.mwsWorkspacesCloudResourceBucketGcpToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mwsWorkspacesCloudResourceBucketGcpToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        project_id: cdktf.stringToTerraform(struct.projectId),
    };
}
exports.mwsWorkspacesCloudResourceBucketGcpToTerraform = mwsWorkspacesCloudResourceBucketGcpToTerraform;
class MwsWorkspacesCloudResourceBucketGcpOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._projectId !== undefined) {
            hasAnyValues = true;
            internalValueResult.projectId = this._projectId;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._projectId = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._projectId = value.projectId;
        }
    }
    get projectId() {
        return this.getStringAttribute('project_id');
    }
    set projectId(value) {
        this._projectId = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectIdInput() {
        return this._projectId;
    }
}
exports.MwsWorkspacesCloudResourceBucketGcpOutputReference = MwsWorkspacesCloudResourceBucketGcpOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MwsWorkspacesCloudResourceBucketGcpOutputReference[_a] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesCloudResourceBucketGcpOutputReference", version: "3.0.2" };
function mwsWorkspacesCloudResourceBucketToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        gcp: mwsWorkspacesCloudResourceBucketGcpToTerraform(struct.gcp),
    };
}
exports.mwsWorkspacesCloudResourceBucketToTerraform = mwsWorkspacesCloudResourceBucketToTerraform;
class MwsWorkspacesCloudResourceBucketOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // gcp - computed: false, optional: false, required: true
        this._gcp = new MwsWorkspacesCloudResourceBucketGcpOutputReference(this, "gcp");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._gcp?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.gcp = this._gcp?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._gcp.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._gcp.internalValue = value.gcp;
        }
    }
    get gcp() {
        return this._gcp;
    }
    putGcp(value) {
        this._gcp.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get gcpInput() {
        return this._gcp.internalValue;
    }
}
exports.MwsWorkspacesCloudResourceBucketOutputReference = MwsWorkspacesCloudResourceBucketOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MwsWorkspacesCloudResourceBucketOutputReference[_b] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesCloudResourceBucketOutputReference", version: "3.0.2" };
function mwsWorkspacesExternalCustomerInfoToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        authoritative_user_email: cdktf.stringToTerraform(struct.authoritativeUserEmail),
        authoritative_user_full_name: cdktf.stringToTerraform(struct.authoritativeUserFullName),
        customer_name: cdktf.stringToTerraform(struct.customerName),
    };
}
exports.mwsWorkspacesExternalCustomerInfoToTerraform = mwsWorkspacesExternalCustomerInfoToTerraform;
class MwsWorkspacesExternalCustomerInfoOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._authoritativeUserEmail !== undefined) {
            hasAnyValues = true;
            internalValueResult.authoritativeUserEmail = this._authoritativeUserEmail;
        }
        if (this._authoritativeUserFullName !== undefined) {
            hasAnyValues = true;
            internalValueResult.authoritativeUserFullName = this._authoritativeUserFullName;
        }
        if (this._customerName !== undefined) {
            hasAnyValues = true;
            internalValueResult.customerName = this._customerName;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._authoritativeUserEmail = undefined;
            this._authoritativeUserFullName = undefined;
            this._customerName = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._authoritativeUserEmail = value.authoritativeUserEmail;
            this._authoritativeUserFullName = value.authoritativeUserFullName;
            this._customerName = value.customerName;
        }
    }
    get authoritativeUserEmail() {
        return this.getStringAttribute('authoritative_user_email');
    }
    set authoritativeUserEmail(value) {
        this._authoritativeUserEmail = value;
    }
    // Temporarily expose input value. Use with caution.
    get authoritativeUserEmailInput() {
        return this._authoritativeUserEmail;
    }
    get authoritativeUserFullName() {
        return this.getStringAttribute('authoritative_user_full_name');
    }
    set authoritativeUserFullName(value) {
        this._authoritativeUserFullName = value;
    }
    // Temporarily expose input value. Use with caution.
    get authoritativeUserFullNameInput() {
        return this._authoritativeUserFullName;
    }
    get customerName() {
        return this.getStringAttribute('customer_name');
    }
    set customerName(value) {
        this._customerName = value;
    }
    // Temporarily expose input value. Use with caution.
    get customerNameInput() {
        return this._customerName;
    }
}
exports.MwsWorkspacesExternalCustomerInfoOutputReference = MwsWorkspacesExternalCustomerInfoOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MwsWorkspacesExternalCustomerInfoOutputReference[_c] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesExternalCustomerInfoOutputReference", version: "3.0.2" };
function mwsWorkspacesNetworkGcpCommonNetworkConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        gke_cluster_master_ip_range: cdktf.stringToTerraform(struct.gkeClusterMasterIpRange),
        gke_connectivity_type: cdktf.stringToTerraform(struct.gkeConnectivityType),
    };
}
exports.mwsWorkspacesNetworkGcpCommonNetworkConfigToTerraform = mwsWorkspacesNetworkGcpCommonNetworkConfigToTerraform;
class MwsWorkspacesNetworkGcpCommonNetworkConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._gkeClusterMasterIpRange !== undefined) {
            hasAnyValues = true;
            internalValueResult.gkeClusterMasterIpRange = this._gkeClusterMasterIpRange;
        }
        if (this._gkeConnectivityType !== undefined) {
            hasAnyValues = true;
            internalValueResult.gkeConnectivityType = this._gkeConnectivityType;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._gkeClusterMasterIpRange = undefined;
            this._gkeConnectivityType = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._gkeClusterMasterIpRange = value.gkeClusterMasterIpRange;
            this._gkeConnectivityType = value.gkeConnectivityType;
        }
    }
    get gkeClusterMasterIpRange() {
        return this.getStringAttribute('gke_cluster_master_ip_range');
    }
    set gkeClusterMasterIpRange(value) {
        this._gkeClusterMasterIpRange = value;
    }
    // Temporarily expose input value. Use with caution.
    get gkeClusterMasterIpRangeInput() {
        return this._gkeClusterMasterIpRange;
    }
    get gkeConnectivityType() {
        return this.getStringAttribute('gke_connectivity_type');
    }
    set gkeConnectivityType(value) {
        this._gkeConnectivityType = value;
    }
    // Temporarily expose input value. Use with caution.
    get gkeConnectivityTypeInput() {
        return this._gkeConnectivityType;
    }
}
exports.MwsWorkspacesNetworkGcpCommonNetworkConfigOutputReference = MwsWorkspacesNetworkGcpCommonNetworkConfigOutputReference;
_d = JSII_RTTI_SYMBOL_1;
MwsWorkspacesNetworkGcpCommonNetworkConfigOutputReference[_d] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesNetworkGcpCommonNetworkConfigOutputReference", version: "3.0.2" };
function mwsWorkspacesNetworkGcpManagedNetworkConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        gke_cluster_pod_ip_range: cdktf.stringToTerraform(struct.gkeClusterPodIpRange),
        gke_cluster_service_ip_range: cdktf.stringToTerraform(struct.gkeClusterServiceIpRange),
        subnet_cidr: cdktf.stringToTerraform(struct.subnetCidr),
    };
}
exports.mwsWorkspacesNetworkGcpManagedNetworkConfigToTerraform = mwsWorkspacesNetworkGcpManagedNetworkConfigToTerraform;
class MwsWorkspacesNetworkGcpManagedNetworkConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._gkeClusterPodIpRange !== undefined) {
            hasAnyValues = true;
            internalValueResult.gkeClusterPodIpRange = this._gkeClusterPodIpRange;
        }
        if (this._gkeClusterServiceIpRange !== undefined) {
            hasAnyValues = true;
            internalValueResult.gkeClusterServiceIpRange = this._gkeClusterServiceIpRange;
        }
        if (this._subnetCidr !== undefined) {
            hasAnyValues = true;
            internalValueResult.subnetCidr = this._subnetCidr;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._gkeClusterPodIpRange = undefined;
            this._gkeClusterServiceIpRange = undefined;
            this._subnetCidr = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._gkeClusterPodIpRange = value.gkeClusterPodIpRange;
            this._gkeClusterServiceIpRange = value.gkeClusterServiceIpRange;
            this._subnetCidr = value.subnetCidr;
        }
    }
    get gkeClusterPodIpRange() {
        return this.getStringAttribute('gke_cluster_pod_ip_range');
    }
    set gkeClusterPodIpRange(value) {
        this._gkeClusterPodIpRange = value;
    }
    // Temporarily expose input value. Use with caution.
    get gkeClusterPodIpRangeInput() {
        return this._gkeClusterPodIpRange;
    }
    get gkeClusterServiceIpRange() {
        return this.getStringAttribute('gke_cluster_service_ip_range');
    }
    set gkeClusterServiceIpRange(value) {
        this._gkeClusterServiceIpRange = value;
    }
    // Temporarily expose input value. Use with caution.
    get gkeClusterServiceIpRangeInput() {
        return this._gkeClusterServiceIpRange;
    }
    get subnetCidr() {
        return this.getStringAttribute('subnet_cidr');
    }
    set subnetCidr(value) {
        this._subnetCidr = value;
    }
    // Temporarily expose input value. Use with caution.
    get subnetCidrInput() {
        return this._subnetCidr;
    }
}
exports.MwsWorkspacesNetworkGcpManagedNetworkConfigOutputReference = MwsWorkspacesNetworkGcpManagedNetworkConfigOutputReference;
_e = JSII_RTTI_SYMBOL_1;
MwsWorkspacesNetworkGcpManagedNetworkConfigOutputReference[_e] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesNetworkGcpManagedNetworkConfigOutputReference", version: "3.0.2" };
function mwsWorkspacesNetworkToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        network_id: cdktf.stringToTerraform(struct.networkId),
        gcp_common_network_config: mwsWorkspacesNetworkGcpCommonNetworkConfigToTerraform(struct.gcpCommonNetworkConfig),
        gcp_managed_network_config: mwsWorkspacesNetworkGcpManagedNetworkConfigToTerraform(struct.gcpManagedNetworkConfig),
    };
}
exports.mwsWorkspacesNetworkToTerraform = mwsWorkspacesNetworkToTerraform;
class MwsWorkspacesNetworkOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // gcp_common_network_config - computed: false, optional: false, required: true
        this._gcpCommonNetworkConfig = new MwsWorkspacesNetworkGcpCommonNetworkConfigOutputReference(this, "gcp_common_network_config");
        // gcp_managed_network_config - computed: false, optional: true, required: false
        this._gcpManagedNetworkConfig = new MwsWorkspacesNetworkGcpManagedNetworkConfigOutputReference(this, "gcp_managed_network_config");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._networkId !== undefined) {
            hasAnyValues = true;
            internalValueResult.networkId = this._networkId;
        }
        if (this._gcpCommonNetworkConfig?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.gcpCommonNetworkConfig = this._gcpCommonNetworkConfig?.internalValue;
        }
        if (this._gcpManagedNetworkConfig?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.gcpManagedNetworkConfig = this._gcpManagedNetworkConfig?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._networkId = undefined;
            this._gcpCommonNetworkConfig.internalValue = undefined;
            this._gcpManagedNetworkConfig.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._networkId = value.networkId;
            this._gcpCommonNetworkConfig.internalValue = value.gcpCommonNetworkConfig;
            this._gcpManagedNetworkConfig.internalValue = value.gcpManagedNetworkConfig;
        }
    }
    get networkId() {
        return this.getStringAttribute('network_id');
    }
    set networkId(value) {
        this._networkId = value;
    }
    resetNetworkId() {
        this._networkId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkIdInput() {
        return this._networkId;
    }
    get gcpCommonNetworkConfig() {
        return this._gcpCommonNetworkConfig;
    }
    putGcpCommonNetworkConfig(value) {
        this._gcpCommonNetworkConfig.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get gcpCommonNetworkConfigInput() {
        return this._gcpCommonNetworkConfig.internalValue;
    }
    get gcpManagedNetworkConfig() {
        return this._gcpManagedNetworkConfig;
    }
    putGcpManagedNetworkConfig(value) {
        this._gcpManagedNetworkConfig.internalValue = value;
    }
    resetGcpManagedNetworkConfig() {
        this._gcpManagedNetworkConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gcpManagedNetworkConfigInput() {
        return this._gcpManagedNetworkConfig.internalValue;
    }
}
exports.MwsWorkspacesNetworkOutputReference = MwsWorkspacesNetworkOutputReference;
_f = JSII_RTTI_SYMBOL_1;
MwsWorkspacesNetworkOutputReference[_f] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesNetworkOutputReference", version: "3.0.2" };
function mwsWorkspacesTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.mwsWorkspacesTimeoutsToTerraform = mwsWorkspacesTimeoutsToTerraform;
class MwsWorkspacesTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.MwsWorkspacesTimeoutsOutputReference = MwsWorkspacesTimeoutsOutputReference;
_g = JSII_RTTI_SYMBOL_1;
MwsWorkspacesTimeoutsOutputReference[_g] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesTimeoutsOutputReference", version: "3.0.2" };
function mwsWorkspacesTokenToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        comment: cdktf.stringToTerraform(struct.comment),
        lifetime_seconds: cdktf.numberToTerraform(struct.lifetimeSeconds),
        token_id: cdktf.stringToTerraform(struct.tokenId),
        token_value: cdktf.stringToTerraform(struct.tokenValue),
    };
}
exports.mwsWorkspacesTokenToTerraform = mwsWorkspacesTokenToTerraform;
class MwsWorkspacesTokenOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._comment !== undefined) {
            hasAnyValues = true;
            internalValueResult.comment = this._comment;
        }
        if (this._lifetimeSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.lifetimeSeconds = this._lifetimeSeconds;
        }
        if (this._tokenId !== undefined) {
            hasAnyValues = true;
            internalValueResult.tokenId = this._tokenId;
        }
        if (this._tokenValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.tokenValue = this._tokenValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._comment = undefined;
            this._lifetimeSeconds = undefined;
            this._tokenId = undefined;
            this._tokenValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._comment = value.comment;
            this._lifetimeSeconds = value.lifetimeSeconds;
            this._tokenId = value.tokenId;
            this._tokenValue = value.tokenValue;
        }
    }
    get comment() {
        return this.getStringAttribute('comment');
    }
    set comment(value) {
        this._comment = value;
    }
    resetComment() {
        this._comment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commentInput() {
        return this._comment;
    }
    get lifetimeSeconds() {
        return this.getNumberAttribute('lifetime_seconds');
    }
    set lifetimeSeconds(value) {
        this._lifetimeSeconds = value;
    }
    resetLifetimeSeconds() {
        this._lifetimeSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lifetimeSecondsInput() {
        return this._lifetimeSeconds;
    }
    get tokenId() {
        return this.getStringAttribute('token_id');
    }
    set tokenId(value) {
        this._tokenId = value;
    }
    resetTokenId() {
        this._tokenId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenIdInput() {
        return this._tokenId;
    }
    get tokenValue() {
        return this.getStringAttribute('token_value');
    }
    set tokenValue(value) {
        this._tokenValue = value;
    }
    resetTokenValue() {
        this._tokenValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenValueInput() {
        return this._tokenValue;
    }
}
exports.MwsWorkspacesTokenOutputReference = MwsWorkspacesTokenOutputReference;
_h = JSII_RTTI_SYMBOL_1;
MwsWorkspacesTokenOutputReference[_h] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspacesTokenOutputReference", version: "3.0.2" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces databricks_mws_workspaces}
*/
class MwsWorkspaces extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/mws_workspaces databricks_mws_workspaces} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MwsWorkspacesConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'databricks_mws_workspaces',
            terraformGeneratorMetadata: {
                providerName: 'databricks',
                providerVersion: '1.4.0',
                providerVersionConstraint: '~> 1.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // cloud_resource_bucket - computed: false, optional: true, required: false
        this._cloudResourceBucket = new MwsWorkspacesCloudResourceBucketOutputReference(this, "cloud_resource_bucket");
        // external_customer_info - computed: false, optional: true, required: false
        this._externalCustomerInfo = new MwsWorkspacesExternalCustomerInfoOutputReference(this, "external_customer_info");
        // network - computed: false, optional: true, required: false
        this._network = new MwsWorkspacesNetworkOutputReference(this, "network");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MwsWorkspacesTimeoutsOutputReference(this, "timeouts");
        // token - computed: false, optional: true, required: false
        this._token = new MwsWorkspacesTokenOutputReference(this, "token");
        this._accountId = config.accountId;
        this._awsRegion = config.awsRegion;
        this._cloud = config.cloud;
        this._creationTime = config.creationTime;
        this._credentialsId = config.credentialsId;
        this._customerManagedKeyId = config.customerManagedKeyId;
        this._deploymentName = config.deploymentName;
        this._id = config.id;
        this._isNoPublicIpEnabled = config.isNoPublicIpEnabled;
        this._location = config.location;
        this._managedServicesCustomerManagedKeyId = config.managedServicesCustomerManagedKeyId;
        this._networkId = config.networkId;
        this._pricingTier = config.pricingTier;
        this._privateAccessSettingsId = config.privateAccessSettingsId;
        this._storageConfigurationId = config.storageConfigurationId;
        this._storageCustomerManagedKeyId = config.storageCustomerManagedKeyId;
        this._workspaceId = config.workspaceId;
        this._workspaceName = config.workspaceName;
        this._workspaceStatus = config.workspaceStatus;
        this._workspaceStatusMessage = config.workspaceStatusMessage;
        this._workspaceUrl = config.workspaceUrl;
        this._cloudResourceBucket.internalValue = config.cloudResourceBucket;
        this._externalCustomerInfo.internalValue = config.externalCustomerInfo;
        this._network.internalValue = config.network;
        this._timeouts.internalValue = config.timeouts;
        this._token.internalValue = config.token;
    }
    get accountId() {
        return this.getStringAttribute('account_id');
    }
    set accountId(value) {
        this._accountId = value;
    }
    // Temporarily expose input value. Use with caution.
    get accountIdInput() {
        return this._accountId;
    }
    get awsRegion() {
        return this.getStringAttribute('aws_region');
    }
    set awsRegion(value) {
        this._awsRegion = value;
    }
    resetAwsRegion() {
        this._awsRegion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsRegionInput() {
        return this._awsRegion;
    }
    get cloud() {
        return this.getStringAttribute('cloud');
    }
    set cloud(value) {
        this._cloud = value;
    }
    resetCloud() {
        this._cloud = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudInput() {
        return this._cloud;
    }
    get creationTime() {
        return this.getNumberAttribute('creation_time');
    }
    set creationTime(value) {
        this._creationTime = value;
    }
    resetCreationTime() {
        this._creationTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get creationTimeInput() {
        return this._creationTime;
    }
    get credentialsId() {
        return this.getStringAttribute('credentials_id');
    }
    set credentialsId(value) {
        this._credentialsId = value;
    }
    resetCredentialsId() {
        this._credentialsId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get credentialsIdInput() {
        return this._credentialsId;
    }
    get customerManagedKeyId() {
        return this.getStringAttribute('customer_managed_key_id');
    }
    set customerManagedKeyId(value) {
        this._customerManagedKeyId = value;
    }
    resetCustomerManagedKeyId() {
        this._customerManagedKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customerManagedKeyIdInput() {
        return this._customerManagedKeyId;
    }
    get deploymentName() {
        return this.getStringAttribute('deployment_name');
    }
    set deploymentName(value) {
        this._deploymentName = value;
    }
    resetDeploymentName() {
        this._deploymentName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deploymentNameInput() {
        return this._deploymentName;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get isNoPublicIpEnabled() {
        return this.getBooleanAttribute('is_no_public_ip_enabled');
    }
    set isNoPublicIpEnabled(value) {
        this._isNoPublicIpEnabled = value;
    }
    resetIsNoPublicIpEnabled() {
        this._isNoPublicIpEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isNoPublicIpEnabledInput() {
        return this._isNoPublicIpEnabled;
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    resetLocation() {
        this._location = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    get managedServicesCustomerManagedKeyId() {
        return this.getStringAttribute('managed_services_customer_managed_key_id');
    }
    set managedServicesCustomerManagedKeyId(value) {
        this._managedServicesCustomerManagedKeyId = value;
    }
    resetManagedServicesCustomerManagedKeyId() {
        this._managedServicesCustomerManagedKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managedServicesCustomerManagedKeyIdInput() {
        return this._managedServicesCustomerManagedKeyId;
    }
    get networkId() {
        return this.getStringAttribute('network_id');
    }
    set networkId(value) {
        this._networkId = value;
    }
    resetNetworkId() {
        this._networkId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkIdInput() {
        return this._networkId;
    }
    get pricingTier() {
        return this.getStringAttribute('pricing_tier');
    }
    set pricingTier(value) {
        this._pricingTier = value;
    }
    resetPricingTier() {
        this._pricingTier = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pricingTierInput() {
        return this._pricingTier;
    }
    get privateAccessSettingsId() {
        return this.getStringAttribute('private_access_settings_id');
    }
    set privateAccessSettingsId(value) {
        this._privateAccessSettingsId = value;
    }
    resetPrivateAccessSettingsId() {
        this._privateAccessSettingsId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateAccessSettingsIdInput() {
        return this._privateAccessSettingsId;
    }
    get storageConfigurationId() {
        return this.getStringAttribute('storage_configuration_id');
    }
    set storageConfigurationId(value) {
        this._storageConfigurationId = value;
    }
    resetStorageConfigurationId() {
        this._storageConfigurationId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageConfigurationIdInput() {
        return this._storageConfigurationId;
    }
    get storageCustomerManagedKeyId() {
        return this.getStringAttribute('storage_customer_managed_key_id');
    }
    set storageCustomerManagedKeyId(value) {
        this._storageCustomerManagedKeyId = value;
    }
    resetStorageCustomerManagedKeyId() {
        this._storageCustomerManagedKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageCustomerManagedKeyIdInput() {
        return this._storageCustomerManagedKeyId;
    }
    get workspaceId() {
        return this.getNumberAttribute('workspace_id');
    }
    set workspaceId(value) {
        this._workspaceId = value;
    }
    resetWorkspaceId() {
        this._workspaceId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceIdInput() {
        return this._workspaceId;
    }
    get workspaceName() {
        return this.getStringAttribute('workspace_name');
    }
    set workspaceName(value) {
        this._workspaceName = value;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceNameInput() {
        return this._workspaceName;
    }
    get workspaceStatus() {
        return this.getStringAttribute('workspace_status');
    }
    set workspaceStatus(value) {
        this._workspaceStatus = value;
    }
    resetWorkspaceStatus() {
        this._workspaceStatus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceStatusInput() {
        return this._workspaceStatus;
    }
    get workspaceStatusMessage() {
        return this.getStringAttribute('workspace_status_message');
    }
    set workspaceStatusMessage(value) {
        this._workspaceStatusMessage = value;
    }
    resetWorkspaceStatusMessage() {
        this._workspaceStatusMessage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceStatusMessageInput() {
        return this._workspaceStatusMessage;
    }
    get workspaceUrl() {
        return this.getStringAttribute('workspace_url');
    }
    set workspaceUrl(value) {
        this._workspaceUrl = value;
    }
    resetWorkspaceUrl() {
        this._workspaceUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workspaceUrlInput() {
        return this._workspaceUrl;
    }
    get cloudResourceBucket() {
        return this._cloudResourceBucket;
    }
    putCloudResourceBucket(value) {
        this._cloudResourceBucket.internalValue = value;
    }
    resetCloudResourceBucket() {
        this._cloudResourceBucket.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudResourceBucketInput() {
        return this._cloudResourceBucket.internalValue;
    }
    get externalCustomerInfo() {
        return this._externalCustomerInfo;
    }
    putExternalCustomerInfo(value) {
        this._externalCustomerInfo.internalValue = value;
    }
    resetExternalCustomerInfo() {
        this._externalCustomerInfo.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalCustomerInfoInput() {
        return this._externalCustomerInfo.internalValue;
    }
    get network() {
        return this._network;
    }
    putNetwork(value) {
        this._network.internalValue = value;
    }
    resetNetwork() {
        this._network.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkInput() {
        return this._network.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    get token() {
        return this._token;
    }
    putToken(value) {
        this._token.internalValue = value;
    }
    resetToken() {
        this._token.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account_id: cdktf.stringToTerraform(this._accountId),
            aws_region: cdktf.stringToTerraform(this._awsRegion),
            cloud: cdktf.stringToTerraform(this._cloud),
            creation_time: cdktf.numberToTerraform(this._creationTime),
            credentials_id: cdktf.stringToTerraform(this._credentialsId),
            customer_managed_key_id: cdktf.stringToTerraform(this._customerManagedKeyId),
            deployment_name: cdktf.stringToTerraform(this._deploymentName),
            id: cdktf.stringToTerraform(this._id),
            is_no_public_ip_enabled: cdktf.booleanToTerraform(this._isNoPublicIpEnabled),
            location: cdktf.stringToTerraform(this._location),
            managed_services_customer_managed_key_id: cdktf.stringToTerraform(this._managedServicesCustomerManagedKeyId),
            network_id: cdktf.stringToTerraform(this._networkId),
            pricing_tier: cdktf.stringToTerraform(this._pricingTier),
            private_access_settings_id: cdktf.stringToTerraform(this._privateAccessSettingsId),
            storage_configuration_id: cdktf.stringToTerraform(this._storageConfigurationId),
            storage_customer_managed_key_id: cdktf.stringToTerraform(this._storageCustomerManagedKeyId),
            workspace_id: cdktf.numberToTerraform(this._workspaceId),
            workspace_name: cdktf.stringToTerraform(this._workspaceName),
            workspace_status: cdktf.stringToTerraform(this._workspaceStatus),
            workspace_status_message: cdktf.stringToTerraform(this._workspaceStatusMessage),
            workspace_url: cdktf.stringToTerraform(this._workspaceUrl),
            cloud_resource_bucket: mwsWorkspacesCloudResourceBucketToTerraform(this._cloudResourceBucket.internalValue),
            external_customer_info: mwsWorkspacesExternalCustomerInfoToTerraform(this._externalCustomerInfo.internalValue),
            network: mwsWorkspacesNetworkToTerraform(this._network.internalValue),
            timeouts: mwsWorkspacesTimeoutsToTerraform(this._timeouts.internalValue),
            token: mwsWorkspacesTokenToTerraform(this._token.internalValue),
        };
    }
}
exports.MwsWorkspaces = MwsWorkspaces;
_j = JSII_RTTI_SYMBOL_1;
MwsWorkspaces[_j] = { fqn: "@cdktf/provider-databricks.mwsWorkspaces.MwsWorkspaces", version: "3.0.2" };
// =================
// STATIC PROPERTIES
// =================
MwsWorkspaces.tfResourceType = "databricks_mws_workspaces";
//# sourceMappingURL=data:application/json;base64,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