import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PermissionAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permission_assignment#id PermissionAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permission_assignment#permissions PermissionAssignment#permissions}
    */
    readonly permissions: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/permission_assignment#principal_id PermissionAssignment#principal_id}
    */
    readonly principalId: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/permission_assignment databricks_permission_assignment}
*/
export declare class PermissionAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_permission_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/permission_assignment databricks_permission_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PermissionAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: PermissionAssignmentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _permissions?;
    get permissions(): string[];
    set permissions(value: string[]);
    get permissionsInput(): string[] | undefined;
    private _principalId?;
    get principalId(): number;
    set principalId(value: number);
    get principalIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
