import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicePrincipalConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal#active ServicePrincipal#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal#allow_cluster_create ServicePrincipal#allow_cluster_create}
    */
    readonly allowClusterCreate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal#allow_instance_pool_create ServicePrincipal#allow_instance_pool_create}
    */
    readonly allowInstancePoolCreate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal#application_id ServicePrincipal#application_id}
    */
    readonly applicationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal#databricks_sql_access ServicePrincipal#databricks_sql_access}
    */
    readonly databricksSqlAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal#display_name ServicePrincipal#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal#external_id ServicePrincipal#external_id}
    */
    readonly externalId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal#force ServicePrincipal#force}
    */
    readonly force?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal#id ServicePrincipal#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/service_principal#workspace_access ServicePrincipal#workspace_access}
    */
    readonly workspaceAccess?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/service_principal databricks_service_principal}
*/
export declare class ServicePrincipal extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_service_principal";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/service_principal databricks_service_principal} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicePrincipalConfig = {}
    */
    constructor(scope: Construct, id: string, config?: ServicePrincipalConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    private _allowClusterCreate?;
    get allowClusterCreate(): boolean | cdktf.IResolvable;
    set allowClusterCreate(value: boolean | cdktf.IResolvable);
    resetAllowClusterCreate(): void;
    get allowClusterCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _allowInstancePoolCreate?;
    get allowInstancePoolCreate(): boolean | cdktf.IResolvable;
    set allowInstancePoolCreate(value: boolean | cdktf.IResolvable);
    resetAllowInstancePoolCreate(): void;
    get allowInstancePoolCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    resetApplicationId(): void;
    get applicationIdInput(): string | undefined;
    private _databricksSqlAccess?;
    get databricksSqlAccess(): boolean | cdktf.IResolvable;
    set databricksSqlAccess(value: boolean | cdktf.IResolvable);
    resetDatabricksSqlAccess(): void;
    get databricksSqlAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _externalId?;
    get externalId(): string;
    set externalId(value: string);
    resetExternalId(): void;
    get externalIdInput(): string | undefined;
    private _force?;
    get force(): boolean | cdktf.IResolvable;
    set force(value: boolean | cdktf.IResolvable);
    resetForce(): void;
    get forceInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _workspaceAccess?;
    get workspaceAccess(): boolean | cdktf.IResolvable;
    set workspaceAccess(value: boolean | cdktf.IResolvable);
    resetWorkspaceAccess(): void;
    get workspaceAccessInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
