import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlPermissionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions#anonymous_function SqlPermissions#anonymous_function}
    */
    readonly anonymousFunction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions#any_file SqlPermissions#any_file}
    */
    readonly anyFile?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions#catalog SqlPermissions#catalog}
    */
    readonly catalog?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions#cluster_id SqlPermissions#cluster_id}
    */
    readonly clusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions#database SqlPermissions#database}
    */
    readonly database?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions#id SqlPermissions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions#table SqlPermissions#table}
    */
    readonly table?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions#view SqlPermissions#view}
    */
    readonly view?: string;
    /**
    * privilege_assignments block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions#privilege_assignments SqlPermissions#privilege_assignments}
    */
    readonly privilegeAssignments?: SqlPermissionsPrivilegeAssignments[] | cdktf.IResolvable;
}
export interface SqlPermissionsPrivilegeAssignments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions#principal SqlPermissions#principal}
    */
    readonly principal: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions#privileges SqlPermissions#privileges}
    */
    readonly privileges: string[];
}
export declare function sqlPermissionsPrivilegeAssignmentsToTerraform(struct?: SqlPermissionsPrivilegeAssignments | cdktf.IResolvable): any;
export declare class SqlPermissionsPrivilegeAssignmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SqlPermissionsPrivilegeAssignments | cdktf.IResolvable | undefined;
    set internalValue(value: SqlPermissionsPrivilegeAssignments | cdktf.IResolvable | undefined);
    private _principal?;
    get principal(): string;
    set principal(value: string);
    get principalInput(): string | undefined;
    private _privileges?;
    get privileges(): string[];
    set privileges(value: string[]);
    get privilegesInput(): string[] | undefined;
}
export declare class SqlPermissionsPrivilegeAssignmentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SqlPermissionsPrivilegeAssignments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SqlPermissionsPrivilegeAssignmentsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions databricks_sql_permissions}
*/
export declare class SqlPermissions extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_sql_permissions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/sql_permissions databricks_sql_permissions} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlPermissionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SqlPermissionsConfig);
    private _anonymousFunction?;
    get anonymousFunction(): boolean | cdktf.IResolvable;
    set anonymousFunction(value: boolean | cdktf.IResolvable);
    resetAnonymousFunction(): void;
    get anonymousFunctionInput(): boolean | cdktf.IResolvable | undefined;
    private _anyFile?;
    get anyFile(): boolean | cdktf.IResolvable;
    set anyFile(value: boolean | cdktf.IResolvable);
    resetAnyFile(): void;
    get anyFileInput(): boolean | cdktf.IResolvable | undefined;
    private _catalog?;
    get catalog(): boolean | cdktf.IResolvable;
    set catalog(value: boolean | cdktf.IResolvable);
    resetCatalog(): void;
    get catalogInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    resetClusterId(): void;
    get clusterIdInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _table?;
    get table(): string;
    set table(value: string);
    resetTable(): void;
    get tableInput(): string | undefined;
    private _view?;
    get view(): string;
    set view(value: string);
    resetView(): void;
    get viewInput(): string | undefined;
    private _privilegeAssignments;
    get privilegeAssignments(): SqlPermissionsPrivilegeAssignmentsList;
    putPrivilegeAssignments(value: SqlPermissionsPrivilegeAssignments[] | cdktf.IResolvable): void;
    resetPrivilegeAssignments(): void;
    get privilegeAssignmentsInput(): cdktf.IResolvable | SqlPermissionsPrivilegeAssignments[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
