import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlQueryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#data_source_id SqlQuery#data_source_id}
    */
    readonly dataSourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#description SqlQuery#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#id SqlQuery#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#name SqlQuery#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#query SqlQuery#query}
    */
    readonly query: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#run_as_role SqlQuery#run_as_role}
    */
    readonly runAsRole?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#tags SqlQuery#tags}
    */
    readonly tags?: string[];
    /**
    * parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#parameter SqlQuery#parameter}
    */
    readonly parameter?: SqlQueryParameter[] | cdktf.IResolvable;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#schedule SqlQuery#schedule}
    */
    readonly schedule?: SqlQuerySchedule;
}
export interface SqlQueryParameterDate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#value SqlQuery#value}
    */
    readonly value: string;
}
export declare function sqlQueryParameterDateToTerraform(struct?: SqlQueryParameterDateOutputReference | SqlQueryParameterDate): any;
export declare class SqlQueryParameterDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterDate | undefined;
    set internalValue(value: SqlQueryParameterDate | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface SqlQueryParameterDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#value SqlQuery#value}
    */
    readonly value: string;
}
export declare function sqlQueryParameterDateRangeToTerraform(struct?: SqlQueryParameterDateRangeOutputReference | SqlQueryParameterDateRange): any;
export declare class SqlQueryParameterDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterDateRange | undefined;
    set internalValue(value: SqlQueryParameterDateRange | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface SqlQueryParameterDatetime {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#value SqlQuery#value}
    */
    readonly value: string;
}
export declare function sqlQueryParameterDatetimeToTerraform(struct?: SqlQueryParameterDatetimeOutputReference | SqlQueryParameterDatetime): any;
export declare class SqlQueryParameterDatetimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterDatetime | undefined;
    set internalValue(value: SqlQueryParameterDatetime | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface SqlQueryParameterDatetimeRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#value SqlQuery#value}
    */
    readonly value: string;
}
export declare function sqlQueryParameterDatetimeRangeToTerraform(struct?: SqlQueryParameterDatetimeRangeOutputReference | SqlQueryParameterDatetimeRange): any;
export declare class SqlQueryParameterDatetimeRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterDatetimeRange | undefined;
    set internalValue(value: SqlQueryParameterDatetimeRange | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface SqlQueryParameterDatetimesec {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#value SqlQuery#value}
    */
    readonly value: string;
}
export declare function sqlQueryParameterDatetimesecToTerraform(struct?: SqlQueryParameterDatetimesecOutputReference | SqlQueryParameterDatetimesec): any;
export declare class SqlQueryParameterDatetimesecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterDatetimesec | undefined;
    set internalValue(value: SqlQueryParameterDatetimesec | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface SqlQueryParameterDatetimesecRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#value SqlQuery#value}
    */
    readonly value: string;
}
export declare function sqlQueryParameterDatetimesecRangeToTerraform(struct?: SqlQueryParameterDatetimesecRangeOutputReference | SqlQueryParameterDatetimesecRange): any;
export declare class SqlQueryParameterDatetimesecRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterDatetimesecRange | undefined;
    set internalValue(value: SqlQueryParameterDatetimesecRange | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface SqlQueryParameterEnumMultiple {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#prefix SqlQuery#prefix}
    */
    readonly prefix: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#separator SqlQuery#separator}
    */
    readonly separator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#suffix SqlQuery#suffix}
    */
    readonly suffix: string;
}
export declare function sqlQueryParameterEnumMultipleToTerraform(struct?: SqlQueryParameterEnumMultipleOutputReference | SqlQueryParameterEnumMultiple): any;
export declare class SqlQueryParameterEnumMultipleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterEnumMultiple | undefined;
    set internalValue(value: SqlQueryParameterEnumMultiple | undefined);
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    get prefixInput(): string | undefined;
    private _separator?;
    get separator(): string;
    set separator(value: string);
    get separatorInput(): string | undefined;
    private _suffix?;
    get suffix(): string;
    set suffix(value: string);
    get suffixInput(): string | undefined;
}
export interface SqlQueryParameterEnum {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#options SqlQuery#options}
    */
    readonly options: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#value SqlQuery#value}
    */
    readonly value?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#values SqlQuery#values}
    */
    readonly values?: string[];
    /**
    * multiple block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#multiple SqlQuery#multiple}
    */
    readonly multiple?: SqlQueryParameterEnumMultiple;
}
export declare function sqlQueryParameterEnumToTerraform(struct?: SqlQueryParameterEnumOutputReference | SqlQueryParameterEnum): any;
export declare class SqlQueryParameterEnumOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterEnum | undefined;
    set internalValue(value: SqlQueryParameterEnum | undefined);
    private _options?;
    get options(): string[];
    set options(value: string[]);
    get optionsInput(): string[] | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
    private _multiple;
    get multiple(): SqlQueryParameterEnumMultipleOutputReference;
    putMultiple(value: SqlQueryParameterEnumMultiple): void;
    resetMultiple(): void;
    get multipleInput(): SqlQueryParameterEnumMultiple | undefined;
}
export interface SqlQueryParameterNumber {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#value SqlQuery#value}
    */
    readonly value: number;
}
export declare function sqlQueryParameterNumberToTerraform(struct?: SqlQueryParameterNumberOutputReference | SqlQueryParameterNumber): any;
export declare class SqlQueryParameterNumberOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterNumber | undefined;
    set internalValue(value: SqlQueryParameterNumber | undefined);
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SqlQueryParameterQueryMultiple {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#prefix SqlQuery#prefix}
    */
    readonly prefix: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#separator SqlQuery#separator}
    */
    readonly separator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#suffix SqlQuery#suffix}
    */
    readonly suffix: string;
}
export declare function sqlQueryParameterQueryMultipleToTerraform(struct?: SqlQueryParameterQueryMultipleOutputReference | SqlQueryParameterQueryMultiple): any;
export declare class SqlQueryParameterQueryMultipleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterQueryMultiple | undefined;
    set internalValue(value: SqlQueryParameterQueryMultiple | undefined);
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    get prefixInput(): string | undefined;
    private _separator?;
    get separator(): string;
    set separator(value: string);
    get separatorInput(): string | undefined;
    private _suffix?;
    get suffix(): string;
    set suffix(value: string);
    get suffixInput(): string | undefined;
}
export interface SqlQueryParameterQuery {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#query_id SqlQuery#query_id}
    */
    readonly queryId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#value SqlQuery#value}
    */
    readonly value?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#values SqlQuery#values}
    */
    readonly values?: string[];
    /**
    * multiple block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#multiple SqlQuery#multiple}
    */
    readonly multiple?: SqlQueryParameterQueryMultiple;
}
export declare function sqlQueryParameterQueryToTerraform(struct?: SqlQueryParameterQueryOutputReference | SqlQueryParameterQuery): any;
export declare class SqlQueryParameterQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterQuery | undefined;
    set internalValue(value: SqlQueryParameterQuery | undefined);
    private _queryId?;
    get queryId(): string;
    set queryId(value: string);
    get queryIdInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
    private _multiple;
    get multiple(): SqlQueryParameterQueryMultipleOutputReference;
    putMultiple(value: SqlQueryParameterQueryMultiple): void;
    resetMultiple(): void;
    get multipleInput(): SqlQueryParameterQueryMultiple | undefined;
}
export interface SqlQueryParameterText {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#value SqlQuery#value}
    */
    readonly value: string;
}
export declare function sqlQueryParameterTextToTerraform(struct?: SqlQueryParameterTextOutputReference | SqlQueryParameterText): any;
export declare class SqlQueryParameterTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryParameterText | undefined;
    set internalValue(value: SqlQueryParameterText | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface SqlQueryParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#name SqlQuery#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#title SqlQuery#title}
    */
    readonly title?: string;
    /**
    * date block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#date SqlQuery#date}
    */
    readonly date?: SqlQueryParameterDate;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#date_range SqlQuery#date_range}
    */
    readonly dateRange?: SqlQueryParameterDateRange;
    /**
    * datetime block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#datetime SqlQuery#datetime}
    */
    readonly datetime?: SqlQueryParameterDatetime;
    /**
    * datetime_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#datetime_range SqlQuery#datetime_range}
    */
    readonly datetimeRange?: SqlQueryParameterDatetimeRange;
    /**
    * datetimesec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#datetimesec SqlQuery#datetimesec}
    */
    readonly datetimesec?: SqlQueryParameterDatetimesec;
    /**
    * datetimesec_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#datetimesec_range SqlQuery#datetimesec_range}
    */
    readonly datetimesecRange?: SqlQueryParameterDatetimesecRange;
    /**
    * enum block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#enum SqlQuery#enum}
    */
    readonly enum?: SqlQueryParameterEnum;
    /**
    * number block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#number SqlQuery#number}
    */
    readonly number?: SqlQueryParameterNumber;
    /**
    * query block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#query SqlQuery#query}
    */
    readonly query?: SqlQueryParameterQuery;
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#text SqlQuery#text}
    */
    readonly text?: SqlQueryParameterText;
}
export declare function sqlQueryParameterToTerraform(struct?: SqlQueryParameter | cdktf.IResolvable): any;
export declare class SqlQueryParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SqlQueryParameter | cdktf.IResolvable | undefined;
    set internalValue(value: SqlQueryParameter | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _date;
    get date(): SqlQueryParameterDateOutputReference;
    putDate(value: SqlQueryParameterDate): void;
    resetDate(): void;
    get dateInput(): SqlQueryParameterDate | undefined;
    private _dateRange;
    get dateRange(): SqlQueryParameterDateRangeOutputReference;
    putDateRange(value: SqlQueryParameterDateRange): void;
    resetDateRange(): void;
    get dateRangeInput(): SqlQueryParameterDateRange | undefined;
    private _datetime;
    get datetime(): SqlQueryParameterDatetimeOutputReference;
    putDatetime(value: SqlQueryParameterDatetime): void;
    resetDatetime(): void;
    get datetimeInput(): SqlQueryParameterDatetime | undefined;
    private _datetimeRange;
    get datetimeRange(): SqlQueryParameterDatetimeRangeOutputReference;
    putDatetimeRange(value: SqlQueryParameterDatetimeRange): void;
    resetDatetimeRange(): void;
    get datetimeRangeInput(): SqlQueryParameterDatetimeRange | undefined;
    private _datetimesec;
    get datetimesec(): SqlQueryParameterDatetimesecOutputReference;
    putDatetimesec(value: SqlQueryParameterDatetimesec): void;
    resetDatetimesec(): void;
    get datetimesecInput(): SqlQueryParameterDatetimesec | undefined;
    private _datetimesecRange;
    get datetimesecRange(): SqlQueryParameterDatetimesecRangeOutputReference;
    putDatetimesecRange(value: SqlQueryParameterDatetimesecRange): void;
    resetDatetimesecRange(): void;
    get datetimesecRangeInput(): SqlQueryParameterDatetimesecRange | undefined;
    private _enum;
    get enum(): SqlQueryParameterEnumOutputReference;
    putEnum(value: SqlQueryParameterEnum): void;
    resetEnum(): void;
    get enumInput(): SqlQueryParameterEnum | undefined;
    private _number;
    get number(): SqlQueryParameterNumberOutputReference;
    putNumber(value: SqlQueryParameterNumber): void;
    resetNumber(): void;
    get numberInput(): SqlQueryParameterNumber | undefined;
    private _query;
    get query(): SqlQueryParameterQueryOutputReference;
    putQuery(value: SqlQueryParameterQuery): void;
    resetQuery(): void;
    get queryInput(): SqlQueryParameterQuery | undefined;
    private _text;
    get text(): SqlQueryParameterTextOutputReference;
    putText(value: SqlQueryParameterText): void;
    resetText(): void;
    get textInput(): SqlQueryParameterText | undefined;
}
export declare class SqlQueryParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SqlQueryParameter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SqlQueryParameterOutputReference;
}
export interface SqlQueryScheduleContinuous {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#interval_seconds SqlQuery#interval_seconds}
    */
    readonly intervalSeconds: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#until_date SqlQuery#until_date}
    */
    readonly untilDate?: string;
}
export declare function sqlQueryScheduleContinuousToTerraform(struct?: SqlQueryScheduleContinuousOutputReference | SqlQueryScheduleContinuous): any;
export declare class SqlQueryScheduleContinuousOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryScheduleContinuous | undefined;
    set internalValue(value: SqlQueryScheduleContinuous | undefined);
    private _intervalSeconds?;
    get intervalSeconds(): number;
    set intervalSeconds(value: number);
    get intervalSecondsInput(): number | undefined;
    private _untilDate?;
    get untilDate(): string;
    set untilDate(value: string);
    resetUntilDate(): void;
    get untilDateInput(): string | undefined;
}
export interface SqlQueryScheduleDaily {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#interval_days SqlQuery#interval_days}
    */
    readonly intervalDays: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#time_of_day SqlQuery#time_of_day}
    */
    readonly timeOfDay: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#until_date SqlQuery#until_date}
    */
    readonly untilDate?: string;
}
export declare function sqlQueryScheduleDailyToTerraform(struct?: SqlQueryScheduleDailyOutputReference | SqlQueryScheduleDaily): any;
export declare class SqlQueryScheduleDailyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryScheduleDaily | undefined;
    set internalValue(value: SqlQueryScheduleDaily | undefined);
    private _intervalDays?;
    get intervalDays(): number;
    set intervalDays(value: number);
    get intervalDaysInput(): number | undefined;
    private _timeOfDay?;
    get timeOfDay(): string;
    set timeOfDay(value: string);
    get timeOfDayInput(): string | undefined;
    private _untilDate?;
    get untilDate(): string;
    set untilDate(value: string);
    resetUntilDate(): void;
    get untilDateInput(): string | undefined;
}
export interface SqlQueryScheduleWeekly {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#day_of_week SqlQuery#day_of_week}
    */
    readonly dayOfWeek: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#interval_weeks SqlQuery#interval_weeks}
    */
    readonly intervalWeeks: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#time_of_day SqlQuery#time_of_day}
    */
    readonly timeOfDay: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#until_date SqlQuery#until_date}
    */
    readonly untilDate?: string;
}
export declare function sqlQueryScheduleWeeklyToTerraform(struct?: SqlQueryScheduleWeeklyOutputReference | SqlQueryScheduleWeekly): any;
export declare class SqlQueryScheduleWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQueryScheduleWeekly | undefined;
    set internalValue(value: SqlQueryScheduleWeekly | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _intervalWeeks?;
    get intervalWeeks(): number;
    set intervalWeeks(value: number);
    get intervalWeeksInput(): number | undefined;
    private _timeOfDay?;
    get timeOfDay(): string;
    set timeOfDay(value: string);
    get timeOfDayInput(): string | undefined;
    private _untilDate?;
    get untilDate(): string;
    set untilDate(value: string);
    resetUntilDate(): void;
    get untilDateInput(): string | undefined;
}
export interface SqlQuerySchedule {
    /**
    * continuous block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#continuous SqlQuery#continuous}
    */
    readonly continuous?: SqlQueryScheduleContinuous;
    /**
    * daily block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#daily SqlQuery#daily}
    */
    readonly daily?: SqlQueryScheduleDaily;
    /**
    * weekly block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_query#weekly SqlQuery#weekly}
    */
    readonly weekly?: SqlQueryScheduleWeekly;
}
export declare function sqlQueryScheduleToTerraform(struct?: SqlQueryScheduleOutputReference | SqlQuerySchedule): any;
export declare class SqlQueryScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlQuerySchedule | undefined;
    set internalValue(value: SqlQuerySchedule | undefined);
    private _continuous;
    get continuous(): SqlQueryScheduleContinuousOutputReference;
    putContinuous(value: SqlQueryScheduleContinuous): void;
    resetContinuous(): void;
    get continuousInput(): SqlQueryScheduleContinuous | undefined;
    private _daily;
    get daily(): SqlQueryScheduleDailyOutputReference;
    putDaily(value: SqlQueryScheduleDaily): void;
    resetDaily(): void;
    get dailyInput(): SqlQueryScheduleDaily | undefined;
    private _weekly;
    get weekly(): SqlQueryScheduleWeeklyOutputReference;
    putWeekly(value: SqlQueryScheduleWeekly): void;
    resetWeekly(): void;
    get weeklyInput(): SqlQueryScheduleWeekly | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/sql_query databricks_sql_query}
*/
export declare class SqlQuery extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_sql_query";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/sql_query databricks_sql_query} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlQueryConfig
    */
    constructor(scope: Construct, id: string, config: SqlQueryConfig);
    private _dataSourceId?;
    get dataSourceId(): string;
    set dataSourceId(value: string);
    get dataSourceIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _runAsRole?;
    get runAsRole(): string;
    set runAsRole(value: string);
    resetRunAsRole(): void;
    get runAsRoleInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _parameter;
    get parameter(): SqlQueryParameterList;
    putParameter(value: SqlQueryParameter[] | cdktf.IResolvable): void;
    resetParameter(): void;
    get parameterInput(): cdktf.IResolvable | SqlQueryParameter[] | undefined;
    private _schedule;
    get schedule(): SqlQueryScheduleOutputReference;
    putSchedule(value: SqlQuerySchedule): void;
    resetSchedule(): void;
    get scheduleInput(): SqlQuerySchedule | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
