import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlWidgetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#dashboard_id SqlWidget#dashboard_id}
    */
    readonly dashboardId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#description SqlWidget#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#id SqlWidget#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#text SqlWidget#text}
    */
    readonly text?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#title SqlWidget#title}
    */
    readonly title?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#visualization_id SqlWidget#visualization_id}
    */
    readonly visualizationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#widget_id SqlWidget#widget_id}
    */
    readonly widgetId?: string;
    /**
    * parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#parameter SqlWidget#parameter}
    */
    readonly parameter?: SqlWidgetParameter[] | cdktf.IResolvable;
    /**
    * position block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#position SqlWidget#position}
    */
    readonly position?: SqlWidgetPosition;
}
export interface SqlWidgetParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#map_to SqlWidget#map_to}
    */
    readonly mapTo?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#name SqlWidget#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#title SqlWidget#title}
    */
    readonly title?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#type SqlWidget#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#value SqlWidget#value}
    */
    readonly value?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#values SqlWidget#values}
    */
    readonly values?: string[];
}
export declare function sqlWidgetParameterToTerraform(struct?: SqlWidgetParameter | cdktf.IResolvable): any;
export declare class SqlWidgetParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SqlWidgetParameter | cdktf.IResolvable | undefined;
    set internalValue(value: SqlWidgetParameter | cdktf.IResolvable | undefined);
    private _mapTo?;
    get mapTo(): string;
    set mapTo(value: string);
    resetMapTo(): void;
    get mapToInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class SqlWidgetParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SqlWidgetParameter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SqlWidgetParameterOutputReference;
}
export interface SqlWidgetPosition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#auto_height SqlWidget#auto_height}
    */
    readonly autoHeight?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#pos_x SqlWidget#pos_x}
    */
    readonly posX?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#pos_y SqlWidget#pos_y}
    */
    readonly posY?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#size_x SqlWidget#size_x}
    */
    readonly sizeX: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget#size_y SqlWidget#size_y}
    */
    readonly sizeY: number;
}
export declare function sqlWidgetPositionToTerraform(struct?: SqlWidgetPositionOutputReference | SqlWidgetPosition): any;
export declare class SqlWidgetPositionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlWidgetPosition | undefined;
    set internalValue(value: SqlWidgetPosition | undefined);
    private _autoHeight?;
    get autoHeight(): boolean | cdktf.IResolvable;
    set autoHeight(value: boolean | cdktf.IResolvable);
    resetAutoHeight(): void;
    get autoHeightInput(): boolean | cdktf.IResolvable | undefined;
    private _posX?;
    get posX(): number;
    set posX(value: number);
    resetPosX(): void;
    get posXInput(): number | undefined;
    private _posY?;
    get posY(): number;
    set posY(value: number);
    resetPosY(): void;
    get posYInput(): number | undefined;
    private _sizeX?;
    get sizeX(): number;
    set sizeX(value: number);
    get sizeXInput(): number | undefined;
    private _sizeY?;
    get sizeY(): number;
    set sizeY(value: number);
    get sizeYInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget databricks_sql_widget}
*/
export declare class SqlWidget extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_sql_widget";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/sql_widget databricks_sql_widget} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlWidgetConfig
    */
    constructor(scope: Construct, id: string, config: SqlWidgetConfig);
    private _dashboardId?;
    get dashboardId(): string;
    set dashboardId(value: string);
    get dashboardIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _visualizationId?;
    get visualizationId(): string;
    set visualizationId(value: string);
    resetVisualizationId(): void;
    get visualizationIdInput(): string | undefined;
    private _widgetId?;
    get widgetId(): string;
    set widgetId(value: string);
    resetWidgetId(): void;
    get widgetIdInput(): string | undefined;
    private _parameter;
    get parameter(): SqlWidgetParameterList;
    putParameter(value: SqlWidgetParameter[] | cdktf.IResolvable): void;
    resetParameter(): void;
    get parameterInput(): cdktf.IResolvable | SqlWidgetParameter[] | undefined;
    private _position;
    get position(): SqlWidgetPositionOutputReference;
    putPosition(value: SqlWidgetPosition): void;
    resetPosition(): void;
    get positionInput(): SqlWidgetPosition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
