import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageCredentialConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#comment StorageCredential#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#id StorageCredential#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#metastore_id StorageCredential#metastore_id}
    */
    readonly metastoreId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#name StorageCredential#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#owner StorageCredential#owner}
    */
    readonly owner?: string;
    /**
    * aws_iam_role block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#aws_iam_role StorageCredential#aws_iam_role}
    */
    readonly awsIamRole?: StorageCredentialAwsIamRole;
    /**
    * azure_managed_identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#azure_managed_identity StorageCredential#azure_managed_identity}
    */
    readonly azureManagedIdentity?: StorageCredentialAzureManagedIdentity;
    /**
    * azure_service_principal block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#azure_service_principal StorageCredential#azure_service_principal}
    */
    readonly azureServicePrincipal?: StorageCredentialAzureServicePrincipal;
}
export interface StorageCredentialAwsIamRole {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#role_arn StorageCredential#role_arn}
    */
    readonly roleArn: string;
}
export declare function storageCredentialAwsIamRoleToTerraform(struct?: StorageCredentialAwsIamRoleOutputReference | StorageCredentialAwsIamRole): any;
export declare class StorageCredentialAwsIamRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageCredentialAwsIamRole | undefined;
    set internalValue(value: StorageCredentialAwsIamRole | undefined);
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
}
export interface StorageCredentialAzureManagedIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#access_connector_id StorageCredential#access_connector_id}
    */
    readonly accessConnectorId: string;
}
export declare function storageCredentialAzureManagedIdentityToTerraform(struct?: StorageCredentialAzureManagedIdentityOutputReference | StorageCredentialAzureManagedIdentity): any;
export declare class StorageCredentialAzureManagedIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageCredentialAzureManagedIdentity | undefined;
    set internalValue(value: StorageCredentialAzureManagedIdentity | undefined);
    private _accessConnectorId?;
    get accessConnectorId(): string;
    set accessConnectorId(value: string);
    get accessConnectorIdInput(): string | undefined;
}
export interface StorageCredentialAzureServicePrincipal {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#application_id StorageCredential#application_id}
    */
    readonly applicationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#client_secret StorageCredential#client_secret}
    */
    readonly clientSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential#directory_id StorageCredential#directory_id}
    */
    readonly directoryId: string;
}
export declare function storageCredentialAzureServicePrincipalToTerraform(struct?: StorageCredentialAzureServicePrincipalOutputReference | StorageCredentialAzureServicePrincipal): any;
export declare class StorageCredentialAzureServicePrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageCredentialAzureServicePrincipal | undefined;
    set internalValue(value: StorageCredentialAzureServicePrincipal | undefined);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    get applicationIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _directoryId?;
    get directoryId(): string;
    set directoryId(value: string);
    get directoryIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential databricks_storage_credential}
*/
export declare class StorageCredential extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_storage_credential";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/storage_credential databricks_storage_credential} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageCredentialConfig
    */
    constructor(scope: Construct, id: string, config: StorageCredentialConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metastoreId?;
    get metastoreId(): string;
    set metastoreId(value: string);
    resetMetastoreId(): void;
    get metastoreIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _owner?;
    get owner(): string;
    set owner(value: string);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _awsIamRole;
    get awsIamRole(): StorageCredentialAwsIamRoleOutputReference;
    putAwsIamRole(value: StorageCredentialAwsIamRole): void;
    resetAwsIamRole(): void;
    get awsIamRoleInput(): StorageCredentialAwsIamRole | undefined;
    private _azureManagedIdentity;
    get azureManagedIdentity(): StorageCredentialAzureManagedIdentityOutputReference;
    putAzureManagedIdentity(value: StorageCredentialAzureManagedIdentity): void;
    resetAzureManagedIdentity(): void;
    get azureManagedIdentityInput(): StorageCredentialAzureManagedIdentity | undefined;
    private _azureServicePrincipal;
    get azureServicePrincipal(): StorageCredentialAzureServicePrincipalOutputReference;
    putAzureServicePrincipal(value: StorageCredentialAzureServicePrincipal): void;
    resetAzureServicePrincipal(): void;
    get azureServicePrincipalInput(): StorageCredentialAzureServicePrincipal | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
