import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#catalog_name Table#catalog_name}
    */
    readonly catalogName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#comment Table#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#data_source_format Table#data_source_format}
    */
    readonly dataSourceFormat: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#id Table#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#name Table#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#owner Table#owner}
    */
    readonly owner?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#properties Table#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#schema_name Table#schema_name}
    */
    readonly schemaName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#storage_credential_name Table#storage_credential_name}
    */
    readonly storageCredentialName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#storage_location Table#storage_location}
    */
    readonly storageLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#table_type Table#table_type}
    */
    readonly tableType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#view_definition Table#view_definition}
    */
    readonly viewDefinition?: string;
    /**
    * column block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#column Table#column}
    */
    readonly column: TableColumn[] | cdktf.IResolvable;
}
export interface TableColumn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#comment Table#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#name Table#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#nullable Table#nullable}
    */
    readonly nullable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#partition_index Table#partition_index}
    */
    readonly partitionIndex?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#position Table#position}
    */
    readonly position: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#type_interval_type Table#type_interval_type}
    */
    readonly typeIntervalType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#type_json Table#type_json}
    */
    readonly typeJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#type_name Table#type_name}
    */
    readonly typeName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#type_precision Table#type_precision}
    */
    readonly typePrecision?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#type_scale Table#type_scale}
    */
    readonly typeScale?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/table#type_text Table#type_text}
    */
    readonly typeText: string;
}
export declare function tableColumnToTerraform(struct?: TableColumn | cdktf.IResolvable): any;
export declare class TableColumnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TableColumn | cdktf.IResolvable | undefined;
    set internalValue(value: TableColumn | cdktf.IResolvable | undefined);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullable?;
    get nullable(): boolean | cdktf.IResolvable;
    set nullable(value: boolean | cdktf.IResolvable);
    resetNullable(): void;
    get nullableInput(): boolean | cdktf.IResolvable | undefined;
    private _partitionIndex?;
    get partitionIndex(): number;
    set partitionIndex(value: number);
    resetPartitionIndex(): void;
    get partitionIndexInput(): number | undefined;
    private _position?;
    get position(): number;
    set position(value: number);
    get positionInput(): number | undefined;
    private _typeIntervalType?;
    get typeIntervalType(): string;
    set typeIntervalType(value: string);
    resetTypeIntervalType(): void;
    get typeIntervalTypeInput(): string | undefined;
    private _typeJson?;
    get typeJson(): string;
    set typeJson(value: string);
    resetTypeJson(): void;
    get typeJsonInput(): string | undefined;
    private _typeName?;
    get typeName(): string;
    set typeName(value: string);
    get typeNameInput(): string | undefined;
    private _typePrecision?;
    get typePrecision(): number;
    set typePrecision(value: number);
    resetTypePrecision(): void;
    get typePrecisionInput(): number | undefined;
    private _typeScale?;
    get typeScale(): number;
    set typeScale(value: number);
    resetTypeScale(): void;
    get typeScaleInput(): number | undefined;
    private _typeText?;
    get typeText(): string;
    set typeText(value: string);
    get typeTextInput(): string | undefined;
}
export declare class TableColumnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TableColumn[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TableColumnOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/table databricks_table}
*/
export declare class Table extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_table";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/table databricks_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TableConfig
    */
    constructor(scope: Construct, id: string, config: TableConfig);
    private _catalogName?;
    get catalogName(): string;
    set catalogName(value: string);
    get catalogNameInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataSourceFormat?;
    get dataSourceFormat(): string;
    set dataSourceFormat(value: string);
    get dataSourceFormatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _owner?;
    get owner(): string;
    set owner(value: string);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    get schemaNameInput(): string | undefined;
    private _storageCredentialName?;
    get storageCredentialName(): string;
    set storageCredentialName(value: string);
    resetStorageCredentialName(): void;
    get storageCredentialNameInput(): string | undefined;
    private _storageLocation?;
    get storageLocation(): string;
    set storageLocation(value: string);
    resetStorageLocation(): void;
    get storageLocationInput(): string | undefined;
    private _tableType?;
    get tableType(): string;
    set tableType(value: string);
    get tableTypeInput(): string | undefined;
    private _viewDefinition?;
    get viewDefinition(): string;
    set viewDefinition(value: string);
    resetViewDefinition(): void;
    get viewDefinitionInput(): string | undefined;
    private _column;
    get column(): TableColumnList;
    putColumn(value: TableColumn[] | cdktf.IResolvable): void;
    get columnInput(): cdktf.IResolvable | TableColumn[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
