import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/token#comment Token#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/token#creation_time Token#creation_time}
    */
    readonly creationTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/token#expiry_time Token#expiry_time}
    */
    readonly expiryTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/token#id Token#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/token#lifetime_seconds Token#lifetime_seconds}
    */
    readonly lifetimeSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/databricks/r/token#token_id Token#token_id}
    */
    readonly tokenId?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/databricks/r/token databricks_token}
*/
export declare class Token extends cdktf.TerraformResource {
    static readonly tfResourceType = "databricks_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/databricks/r/token databricks_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TokenConfig = {}
    */
    constructor(scope: Construct, id: string, config?: TokenConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _creationTime?;
    get creationTime(): number;
    set creationTime(value: number);
    resetCreationTime(): void;
    get creationTimeInput(): number | undefined;
    private _expiryTime?;
    get expiryTime(): number;
    set expiryTime(value: number);
    resetExpiryTime(): void;
    get expiryTimeInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lifetimeSeconds?;
    get lifetimeSeconds(): number;
    set lifetimeSeconds(value: number);
    resetLifetimeSeconds(): void;
    get lifetimeSecondsInput(): number | undefined;
    private _tokenId?;
    get tokenId(): string;
    set tokenId(value: string);
    resetTokenId(): void;
    get tokenIdInput(): string | undefined;
    get tokenValue(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
