# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictBytes, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class BangladeshNidInput(BaseModel):
    """
    BangladeshNidInput
    """ # noqa: E501
    national_id_number: Annotated[str, Field(min_length=10, strict=True, max_length=17)] = Field(description="The user's Bangladesh National ID number.", alias="nationalIdNumber")
    date_of_birth: date = Field(description="The user's date of birth, in `YYYY-MM-DD` format", alias="dateOfBirth")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=80)] = Field(description="The user's full name")
    photo_byes: Optional[Union[StrictBytes, StrictStr]] = Field(default=None, description="The raw bytes of the photo file collected from the user.", alias="photoByes")
    photo_image_mime_type: Optional[StrictStr] = Field(default=None, description="The MIME Type of the file contained in `PhotoByes`.              Must be one of `image/jpeg`, or `image/png`.", alias="photoImageMimeType")
    __properties: ClassVar[List[str]] = ["nationalIdNumber", "dateOfBirth", "name", "photoByes", "photoImageMimeType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BangladeshNidInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if photo_byes (nullable) is None
        # and model_fields_set contains the field
        if self.photo_byes is None and "photo_byes" in self.model_fields_set:
            _dict['photoByes'] = None

        # set to None if photo_image_mime_type (nullable) is None
        # and model_fields_set contains the field
        if self.photo_image_mime_type is None and "photo_image_mime_type" in self.model_fields_set:
            _dict['photoImageMimeType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BangladeshNidInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "nationalIdNumber": obj.get("nationalIdNumber"),
            "dateOfBirth": obj.get("dateOfBirth"),
            "name": obj.get("name"),
            "photoByes": obj.get("photoByes"),
            "photoImageMimeType": obj.get("photoImageMimeType")
        })
        return _obj


