# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from trinsic_api.models.integration_capability import IntegrationCapability
from trinsic_api.models.provider_input import ProviderInput
from typing import Optional, Set
from typing_extensions import Self

class CreateAdvancedProviderSessionRequest(BaseModel):
    """
    CreateAdvancedProviderSessionRequest
    """ # noqa: E501
    provider: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The ID of the provider to launch")
    redirect_url: Optional[StrictStr] = Field(default=None, description="The Redirect URL to which the user should be sent after the session is complete.              This field is required for providers which employ a redirect-based flow.", alias="redirectUrl")
    capabilities: Annotated[List[IntegrationCapability], Field(min_length=1)] = Field(description="The list of capabilities your integration supports. Capabilities are the core of Trinsic's whitelabel-with-optional-fallback offering.              Most capabilities align with either an `IntegrationLaunchMethod` or an `IntegrationCollectionMethod`. The exception being refresh content to support updating the content of the launch method.              For example, to support a basic redirect-based flow, you must include the `LaunchRedirect` and `CaptureRedirect` capabilities. To support a mobile deeplink / polling flow, you must include the `DeeplinkToMobile` and `PollForResults` capabilities.              If `FallbackToHostedUi` is `true`, Trinsic will automatically fall back to a Trinsic-hosted UI to cover any gaps in your integration's capabilities. If `FallbackToHostedUi` is `false`, gaps in your integration's capabilities will result in an error during Session creation.              Read more on how to integrate at <a href=\"https://docs.trinsic.id/docs/advanced-provider-sessions\">the guide on Advanced Provider Sessions</a>")
    fallback_to_hosted_ui: Optional[StrictBool] = Field(default=None, description="Whether the session should fall back to a Trinsic-hosted UI in certain instances.              Specifically, fallback will occur if any of the following are true: - You attempted to launch a provider which requires a capability you did not express support for     - In this case, Trinsic's hosted UI will perform the necessary capability - You attempted to launch a provider which requires input, and the input was either not provided or incomplete     - In this case, Trinsic's hosted UI will collect the necessary input from the user              If fallback occurs, the session's NextStep will always be LaunchBrowser, and the CollectionMethod will always be CaptureRedirect.              If this field is set to `true`, you must also: 1. Set the `RedirectUrl` field to a non-empty value 2. Include the `LaunchBrowser` and `CaptureRedirect` capabilities in the `Capabilities` field", alias="fallbackToHostedUI")
    provider_input: Optional[ProviderInput] = Field(default=None, description="Provider-specific input for those providers which require it.", alias="providerInput")
    __properties: ClassVar[List[str]] = ["provider", "redirectUrl", "capabilities", "fallbackToHostedUI", "providerInput"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateAdvancedProviderSessionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of provider_input
        if self.provider_input:
            _dict['providerInput'] = self.provider_input.to_dict()
        # set to None if redirect_url (nullable) is None
        # and model_fields_set contains the field
        if self.redirect_url is None and "redirect_url" in self.model_fields_set:
            _dict['redirectUrl'] = None

        # set to None if fallback_to_hosted_ui (nullable) is None
        # and model_fields_set contains the field
        if self.fallback_to_hosted_ui is None and "fallback_to_hosted_ui" in self.model_fields_set:
            _dict['fallbackToHostedUI'] = None

        # set to None if provider_input (nullable) is None
        # and model_fields_set contains the field
        if self.provider_input is None and "provider_input" in self.model_fields_set:
            _dict['providerInput'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateAdvancedProviderSessionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "provider": obj.get("provider"),
            "redirectUrl": obj.get("redirectUrl"),
            "capabilities": obj.get("capabilities"),
            "fallbackToHostedUI": obj.get("fallbackToHostedUI"),
            "providerInput": ProviderInput.from_dict(obj["providerInput"]) if obj.get("providerInput") is not None else None
        })
        return _obj


