# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from trinsic_api.models.provider_input import ProviderInput
from typing import Optional, Set
from typing_extensions import Self

class CreateHostedProviderSessionRequest(BaseModel):
    """
    CreateHostedProviderSessionRequest
    """ # noqa: E501
    provider: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The ID of the provider to launch")
    redirect_url: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The Redirect URL to which the user should be sent after the session is complete.", alias="redirectUrl")
    provider_input: Optional[ProviderInput] = Field(default=None, description="Provider-specific input for those providers which require it.   <b>Deprecated:</b> In the future, Hosted Provider Sessions will not accept input on creation, and will instead always redirect the user to a hosted interface to collect input. If you need to collect input from the user yourself, please use the Create Advanced Session endpoint instead.", alias="providerInput")
    __properties: ClassVar[List[str]] = ["provider", "redirectUrl", "providerInput"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateHostedProviderSessionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of provider_input
        if self.provider_input:
            _dict['providerInput'] = self.provider_input.to_dict()
        # set to None if provider_input (nullable) is None
        # and model_fields_set contains the field
        if self.provider_input is None and "provider_input" in self.model_fields_set:
            _dict['providerInput'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateHostedProviderSessionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "provider": obj.get("provider"),
            "redirectUrl": obj.get("redirectUrl"),
            "providerInput": ProviderInput.from_dict(obj["providerInput"]) if obj.get("providerInput") is not None else None
        })
        return _obj


