# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from trinsic_api.models.recommendation_info import RecommendationInfo
from typing import Optional, Set
from typing_extensions import Self

class CreateWidgetSessionRequest(BaseModel):
    """
    CreateWidgetSessionRequest
    """ # noqa: E501
    redirect_url: Optional[StrictStr] = Field(default=None, description="The URL to redirect the user to after the widget session is complete.              *Note*: this should NOT be set if you intend to use Trinsic's Web UI SDK to launch the Widget as an embedded iFrame or popup; in that case, session resolution is handled by our SDK, not via redirect.", alias="redirectUrl")
    providers: Optional[List[StrictStr]] = Field(default=None, description="The list of allowed identity providers. If not specified, all available providers will be allowed.")
    recommendation_info: Optional[RecommendationInfo] = Field(default=None, description="Data that you already know about the user being verified.   This data is used to improve the user experience during provider selection, by surfacing the most relevant providers first.", alias="recommendationInfo")
    __properties: ClassVar[List[str]] = ["redirectUrl", "providers", "recommendationInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateWidgetSessionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of recommendation_info
        if self.recommendation_info:
            _dict['recommendationInfo'] = self.recommendation_info.to_dict()
        # set to None if redirect_url (nullable) is None
        # and model_fields_set contains the field
        if self.redirect_url is None and "redirect_url" in self.model_fields_set:
            _dict['redirectUrl'] = None

        # set to None if providers (nullable) is None
        # and model_fields_set contains the field
        if self.providers is None and "providers" in self.model_fields_set:
            _dict['providers'] = None

        # set to None if recommendation_info (nullable) is None
        # and model_fields_set contains the field
        if self.recommendation_info is None and "recommendation_info" in self.model_fields_set:
            _dict['recommendationInfo'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateWidgetSessionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "redirectUrl": obj.get("redirectUrl"),
            "providers": obj.get("providers"),
            "recommendationInfo": RecommendationInfo.from_dict(obj["recommendationInfo"]) if obj.get("recommendationInfo") is not None else None
        })
        return _obj


