# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from trinsic_api.models.attachment_access_keys import AttachmentAccessKeys
from trinsic_api.models.document_data import DocumentData
from trinsic_api.models.person_data import PersonData
from typing import Optional, Set
from typing_extensions import Self

class IdentityData(BaseModel):
    """
    IdentityData
    """ # noqa: E501
    originating_provider_id: Optional[StrictStr] = Field(default=None, alias="originatingProviderId")
    originating_sub_provider_id: Optional[StrictStr] = Field(default=None, alias="originatingSubProviderId")
    person: Optional[PersonData] = None
    document: Optional[DocumentData] = None
    attachment_access_keys: Optional[AttachmentAccessKeys] = Field(default=None, alias="attachmentAccessKeys")
    __properties: ClassVar[List[str]] = ["originatingProviderId", "originatingSubProviderId", "person", "document", "attachmentAccessKeys"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IdentityData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict['person'] = self.person.to_dict()
        # override the default output from pydantic by calling `to_dict()` of document
        if self.document:
            _dict['document'] = self.document.to_dict()
        # override the default output from pydantic by calling `to_dict()` of attachment_access_keys
        if self.attachment_access_keys:
            _dict['attachmentAccessKeys'] = self.attachment_access_keys.to_dict()
        # set to None if originating_provider_id (nullable) is None
        # and model_fields_set contains the field
        if self.originating_provider_id is None and "originating_provider_id" in self.model_fields_set:
            _dict['originatingProviderId'] = None

        # set to None if originating_sub_provider_id (nullable) is None
        # and model_fields_set contains the field
        if self.originating_sub_provider_id is None and "originating_sub_provider_id" in self.model_fields_set:
            _dict['originatingSubProviderId'] = None

        # set to None if person (nullable) is None
        # and model_fields_set contains the field
        if self.person is None and "person" in self.model_fields_set:
            _dict['person'] = None

        # set to None if document (nullable) is None
        # and model_fields_set contains the field
        if self.document is None and "document" in self.model_fields_set:
            _dict['document'] = None

        # set to None if attachment_access_keys (nullable) is None
        # and model_fields_set contains the field
        if self.attachment_access_keys is None and "attachment_access_keys" in self.model_fields_set:
            _dict['attachmentAccessKeys'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IdentityData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "originatingProviderId": obj.get("originatingProviderId"),
            "originatingSubProviderId": obj.get("originatingSubProviderId"),
            "person": PersonData.from_dict(obj["person"]) if obj.get("person") is not None else None,
            "document": DocumentData.from_dict(obj["document"]) if obj.get("document") is not None else None,
            "attachmentAccessKeys": AttachmentAccessKeys.from_dict(obj["attachmentAccessKeys"]) if obj.get("attachmentAccessKeys") is not None else None
        })
        return _obj


