# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from trinsic_api.models.integration_launch_method import IntegrationLaunchMethod
from trinsic_api.models.step_refresh_info import StepRefreshInfo
from typing import Optional, Set
from typing_extensions import Self

class IntegrationStep(BaseModel):
    """
    A step to perform in the process of executing an Advanced Provider Session
    """ # noqa: E501
    method: IntegrationLaunchMethod = Field(description="The launch method to perform")
    content: StrictStr = Field(description="Step type-specific content related to the step: a URL for `LaunchBrowser`, a deeplink for `DeeplinkToMobile` or a string to show to the user for `ShowContent`.")
    refresh: Optional[StepRefreshInfo] = Field(default=None, description="If non-null, contains metadata about how to refresh the value of `content`.")
    __properties: ClassVar[List[str]] = ["method", "content", "refresh"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IntegrationStep from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of refresh
        if self.refresh:
            _dict['refresh'] = self.refresh.to_dict()
        # set to None if refresh (nullable) is None
        # and model_fields_set contains the field
        if self.refresh is None and "refresh" in self.model_fields_set:
            _dict['refresh'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IntegrationStep from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "method": obj.get("method"),
            "content": obj.get("content"),
            "refresh": StepRefreshInfo.from_dict(obj["refresh"]) if obj.get("refresh") is not None else None
        })
        return _obj


