# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from trinsic_api.models.address import Address
from trinsic_api.models.sex import Sex
from typing import Optional, Set
from typing_extensions import Self

class PersonData(BaseModel):
    """
    PersonData
    """ # noqa: E501
    given_name: Optional[StrictStr] = Field(default=None, alias="givenName")
    family_name: Optional[StrictStr] = Field(default=None, alias="familyName")
    middle_name: Optional[StrictStr] = Field(default=None, alias="middleName")
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    suffix: Optional[StrictStr] = None
    nationality: Optional[StrictStr] = None
    sex: Optional[Sex] = None
    phone_number: Optional[StrictStr] = Field(default=None, alias="phoneNumber")
    address: Optional[Address] = None
    date_of_birth: Optional[date] = Field(default=None, alias="dateOfBirth")
    __properties: ClassVar[List[str]] = ["givenName", "familyName", "middleName", "fullName", "suffix", "nationality", "sex", "phoneNumber", "address", "dateOfBirth"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PersonData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # set to None if given_name (nullable) is None
        # and model_fields_set contains the field
        if self.given_name is None and "given_name" in self.model_fields_set:
            _dict['givenName'] = None

        # set to None if family_name (nullable) is None
        # and model_fields_set contains the field
        if self.family_name is None and "family_name" in self.model_fields_set:
            _dict['familyName'] = None

        # set to None if middle_name (nullable) is None
        # and model_fields_set contains the field
        if self.middle_name is None and "middle_name" in self.model_fields_set:
            _dict['middleName'] = None

        # set to None if full_name (nullable) is None
        # and model_fields_set contains the field
        if self.full_name is None and "full_name" in self.model_fields_set:
            _dict['fullName'] = None

        # set to None if suffix (nullable) is None
        # and model_fields_set contains the field
        if self.suffix is None and "suffix" in self.model_fields_set:
            _dict['suffix'] = None

        # set to None if nationality (nullable) is None
        # and model_fields_set contains the field
        if self.nationality is None and "nationality" in self.model_fields_set:
            _dict['nationality'] = None

        # set to None if sex (nullable) is None
        # and model_fields_set contains the field
        if self.sex is None and "sex" in self.model_fields_set:
            _dict['sex'] = None

        # set to None if phone_number (nullable) is None
        # and model_fields_set contains the field
        if self.phone_number is None and "phone_number" in self.model_fields_set:
            _dict['phoneNumber'] = None

        # set to None if address (nullable) is None
        # and model_fields_set contains the field
        if self.address is None and "address" in self.model_fields_set:
            _dict['address'] = None

        # set to None if date_of_birth (nullable) is None
        # and model_fields_set contains the field
        if self.date_of_birth is None and "date_of_birth" in self.model_fields_set:
            _dict['dateOfBirth'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PersonData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "givenName": obj.get("givenName"),
            "familyName": obj.get("familyName"),
            "middleName": obj.get("middleName"),
            "fullName": obj.get("fullName"),
            "suffix": obj.get("suffix"),
            "nationality": obj.get("nationality"),
            "sex": obj.get("sex"),
            "phoneNumber": obj.get("phoneNumber"),
            "address": Address.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "dateOfBirth": obj.get("dateOfBirth")
        })
        return _obj


