# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from trinsic_api.models.contract_field import ContractField
from trinsic_api.models.integration_launch_method import IntegrationLaunchMethod
from trinsic_api.models.provider_health import ProviderHealth
from trinsic_api.models.result_collection_method import ResultCollectionMethod
from trinsic_api.models.sub_provider_metadata import SubProviderMetadata
from typing import Optional, Set
from typing_extensions import Self

class ProviderContract(BaseModel):
    """
    ProviderContract
    """ # noqa: E501
    id: StrictStr = Field(description="The ID of the Provider for this contract.")
    name: StrictStr = Field(description="The Provider's Name as it appears in Trinsic's Dashboard and Widget")
    subtext: StrictStr = Field(description="The Provider's subtext recommended to be shown next to the name.              This is flavor text, not a full, human-readable description of the provider.")
    description: StrictStr = Field(description="The Provider's description as it appears in Trinsic's Widget.              This is flavor text, not a full, human-readable description of the provider.")
    logo_url: StrictStr = Field(description="A URL pointing to the Provider's logo on Trinsic's CDN.              May be a PNG, JPG, or SVG image.", alias="logoUrl")
    available: StrictBool = Field(description="Whether the Provider is available for use in your App.              If `false`, you will need to contact Trinsic to enable this Provider for your App.")
    geography: List[StrictStr] = Field(description="The geographies within the Regions the Provider is available.")
    regions: List[StrictStr] = Field(description="The regions within which the Provider is available.")
    launch_method: IntegrationLaunchMethod = Field(description="Relevant only to Advanced Provider Sessions.              The `LaunchMethod` which must be supported to launch the Provider Session in Advanced Provider Sessions.", alias="launchMethod")
    collection_method: ResultCollectionMethod = Field(description="Relevant only to Advanced Provider Sessions.              The `CollectionMethod` which must be supported to launch the Provider Session in Advanced Provider Sessions.", alias="collectionMethod")
    results_may_be_delayed_after_redirect: StrictBool = Field(description="If `true`, then the results for this Provider may not be available immediately after the user is redirected back to your application. In this case, the `GetSessionResults` API must be called until results are available.              This is an uncommon scenario, and only applies to Providers which cannot guarantee the availability of results immediately after the user is redirected back to your application.", alias="resultsMayBeDelayedAfterRedirect")
    has_refreshable_content: StrictBool = Field(description="Relevant only to Advanced Provider Sessions.              Whether the Provider requires the `RefreshStepContent` capability.              For example, Samsung Wallet's deep links expire every 30 seconds, and must be refreshed periodically for a resilient user flow.", alias="hasRefreshableContent")
    requires_input: StrictBool = Field(description="Relevant to Hosted Provider Sessions and Advanced Provider Sessions.              If `true`, this Provider requires provider-specific input on Session creation. If this input is not provided, Trinsic's Hosted UI will be invoked to collect the input from the user.", alias="requiresInput")
    has_trinsic_interface: StrictBool = Field(description="Whether there exists a Trinsic-hosted UI for this Provider.              This is `true` for any Provider which is not a simple, OIDC-like redirect flow.", alias="hasTrinsicInterface")
    supports_advanced_provider_sessions: StrictBool = Field(description="Whether this Provider can be fully whitelabeled/OEMed through the Advanced Provider Sessions API.              If `false`, the Provider may still be launched through Advanced Provider Sessions; however, it will necessarily require a Trinsic-hosted UI to function.", alias="supportsAdvancedProviderSessions")
    available_fields: Optional[List[ContractField]] = Field(default=None, description="Information about the fields that this Provider will return in verification results.", alias="availableFields")
    sub_providers: Optional[List[SubProviderMetadata]] = Field(default=None, description="Metadata about the sub-providers which are available for this Provider.              For example, Italy's SPID is a Provider which aggregates access to multiple sub-providers.", alias="subProviders")
    health: ProviderHealth = Field(description="The health for an integration to be able to successfully perform a verification session.")
    __properties: ClassVar[List[str]] = ["id", "name", "subtext", "description", "logoUrl", "available", "geography", "regions", "launchMethod", "collectionMethod", "resultsMayBeDelayedAfterRedirect", "hasRefreshableContent", "requiresInput", "hasTrinsicInterface", "supportsAdvancedProviderSessions", "availableFields", "subProviders", "health"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProviderContract from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in available_fields (list)
        _items = []
        if self.available_fields:
            for _item_available_fields in self.available_fields:
                if _item_available_fields:
                    _items.append(_item_available_fields.to_dict())
            _dict['availableFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sub_providers (list)
        _items = []
        if self.sub_providers:
            for _item_sub_providers in self.sub_providers:
                if _item_sub_providers:
                    _items.append(_item_sub_providers.to_dict())
            _dict['subProviders'] = _items
        # set to None if available_fields (nullable) is None
        # and model_fields_set contains the field
        if self.available_fields is None and "available_fields" in self.model_fields_set:
            _dict['availableFields'] = None

        # set to None if sub_providers (nullable) is None
        # and model_fields_set contains the field
        if self.sub_providers is None and "sub_providers" in self.model_fields_set:
            _dict['subProviders'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProviderContract from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "subtext": obj.get("subtext"),
            "description": obj.get("description"),
            "logoUrl": obj.get("logoUrl"),
            "available": obj.get("available"),
            "geography": obj.get("geography"),
            "regions": obj.get("regions"),
            "launchMethod": obj.get("launchMethod"),
            "collectionMethod": obj.get("collectionMethod"),
            "resultsMayBeDelayedAfterRedirect": obj.get("resultsMayBeDelayedAfterRedirect"),
            "hasRefreshableContent": obj.get("hasRefreshableContent"),
            "requiresInput": obj.get("requiresInput"),
            "hasTrinsicInterface": obj.get("hasTrinsicInterface"),
            "supportsAdvancedProviderSessions": obj.get("supportsAdvancedProviderSessions"),
            "availableFields": [ContractField.from_dict(_item) for _item in obj["availableFields"]] if obj.get("availableFields") is not None else None,
            "subProviders": [SubProviderMetadata.from_dict(_item) for _item in obj["subProviders"]] if obj.get("subProviders") is not None else None,
            "health": obj.get("health")
        })
        return _obj


