# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from trinsic_api.models.sub_provider_metadata import SubProviderMetadata
from typing import Optional, Set
from typing_extensions import Self

class ProviderInformation(BaseModel):
    """
    ProviderInformation
    """ # noqa: E501
    id: StrictStr = Field(description="The ID of the provider")
    name: StrictStr = Field(description="The friendly, human-readable name of the provider")
    logo_url: StrictStr = Field(description="A URL pointing to the provider's logo", alias="logoUrl")
    subtext: StrictStr = Field(description="The Provider's subtext recommended to be shown next to the name.              This is flavor text, not a full, human-readable description of the provider.")
    provider_id: StrictStr = Field(description="The ID of the provider", alias="providerId")
    provider_display_name: StrictStr = Field(description="The friendly, human-readable name of the provider", alias="providerDisplayName")
    provider_logo: StrictStr = Field(description="A URL pointing to the provider's logo", alias="providerLogo")
    health: StrictStr = Field(description="The current health status of the provider")
    sub_providers: Optional[List[SubProviderMetadata]] = Field(default=None, description="Metadata about the sub-providers which are available for this Provider.              For example, Italy's SPID is a Provider which aggregates access to multiple sub-providers.", alias="subProviders")
    __properties: ClassVar[List[str]] = ["id", "name", "logoUrl", "subtext", "providerId", "providerDisplayName", "providerLogo", "health", "subProviders"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProviderInformation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sub_providers (list)
        _items = []
        if self.sub_providers:
            for _item_sub_providers in self.sub_providers:
                if _item_sub_providers:
                    _items.append(_item_sub_providers.to_dict())
            _dict['subProviders'] = _items
        # set to None if sub_providers (nullable) is None
        # and model_fields_set contains the field
        if self.sub_providers is None and "sub_providers" in self.model_fields_set:
            _dict['subProviders'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProviderInformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "logoUrl": obj.get("logoUrl"),
            "subtext": obj.get("subtext"),
            "providerId": obj.get("providerId"),
            "providerDisplayName": obj.get("providerDisplayName"),
            "providerLogo": obj.get("providerLogo"),
            "health": obj.get("health"),
            "subProviders": [SubProviderMetadata.from_dict(_item) for _item in obj["subProviders"]] if obj.get("subProviders") is not None else None
        })
        return _obj


