# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from trinsic_api.models.provider_information import ProviderInformation
from typing import Optional, Set
from typing_extensions import Self

class RecommendResponse(BaseModel):
    """
    RecommendResponse
    """ # noqa: E501
    recognized: List[ProviderInformation] = Field(description="The providers which the user is known to have a credential with.")
    relevant: List[ProviderInformation] = Field(description="The providers which the user is deemed sufficiently likely to have a credential with.")
    remainder: List[ProviderInformation] = Field(description="The providers which the user is unlikely to have a credential with.              This includes all providers available to your app which were not included in the Recognized or Relevant lists.")
    __properties: ClassVar[List[str]] = ["recognized", "relevant", "remainder"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RecommendResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in recognized (list)
        _items = []
        if self.recognized:
            for _item_recognized in self.recognized:
                if _item_recognized:
                    _items.append(_item_recognized.to_dict())
            _dict['recognized'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in relevant (list)
        _items = []
        if self.relevant:
            for _item_relevant in self.relevant:
                if _item_relevant:
                    _items.append(_item_relevant.to_dict())
            _dict['relevant'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in remainder (list)
        _items = []
        if self.remainder:
            for _item_remainder in self.remainder:
                if _item_remainder:
                    _items.append(_item_remainder.to_dict())
            _dict['remainder'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RecommendResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "recognized": [ProviderInformation.from_dict(_item) for _item in obj["recognized"]] if obj.get("recognized") is not None else None,
            "relevant": [ProviderInformation.from_dict(_item) for _item in obj["relevant"]] if obj.get("relevant") is not None else None,
            "remainder": [ProviderInformation.from_dict(_item) for _item in obj["remainder"]] if obj.get("remainder") is not None else None
        })
        return _obj


