# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RecommendationInfo(BaseModel):
    """
    Information relating to a user; used to generated Identity Provider recommendations.
    """ # noqa: E501
    phone_number: Optional[StrictStr] = Field(default=None, description="The phone number of the user you wish to generate a recommendation for.              Will be used to look up the user's identity in the network, as well as to determine the user's geographic location.", alias="phoneNumber")
    countries: Optional[List[StrictStr]] = Field(default=None, description="A list of countries, in alpha-2 ISO 3166 format, which the user is related to.              This can include the user's country of residence, nationality, etc.")
    subdivisions: Optional[List[StrictStr]] = Field(default=None, description="If one of the countries has subdivisions (for example: US states), specify those related to the user here (e.g., CA, UT, NY)")
    ip_addresses: Optional[List[StrictStr]] = Field(default=None, description="Any IP addresses related to the user.              Will be used to determine the user's geographic location.", alias="ipAddresses")
    __properties: ClassVar[List[str]] = ["phoneNumber", "countries", "subdivisions", "ipAddresses"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RecommendationInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if phone_number (nullable) is None
        # and model_fields_set contains the field
        if self.phone_number is None and "phone_number" in self.model_fields_set:
            _dict['phoneNumber'] = None

        # set to None if countries (nullable) is None
        # and model_fields_set contains the field
        if self.countries is None and "countries" in self.model_fields_set:
            _dict['countries'] = None

        # set to None if subdivisions (nullable) is None
        # and model_fields_set contains the field
        if self.subdivisions is None and "subdivisions" in self.model_fields_set:
            _dict['subdivisions'] = None

        # set to None if ip_addresses (nullable) is None
        # and model_fields_set contains the field
        if self.ip_addresses is None and "ip_addresses" in self.model_fields_set:
            _dict['ipAddresses'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RecommendationInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "phoneNumber": obj.get("phoneNumber"),
            "countries": obj.get("countries"),
            "subdivisions": obj.get("subdivisions"),
            "ipAddresses": obj.get("ipAddresses")
        })
        return _obj


