# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class SouthAfricaNidInput(BaseModel):
    """
    SouthAfricaNidInput
    """ # noqa: E501
    full_name: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The user's full name as it appears in their National ID", alias="fullName")
    date_of_birth: date = Field(description="The user's date of birth, in `YYYY-MM-DD` format", alias="dateOfBirth")
    gender: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The user's gender as it appears in their National ID (e.g., male, female)")
    national_id_number: Annotated[str, Field(min_length=13, strict=True, max_length=13)] = Field(description="The user's South African National ID number", alias="nationalIdNumber")
    __properties: ClassVar[List[str]] = ["fullName", "dateOfBirth", "gender", "nationalIdNumber"]

    @field_validator('national_id_number')
    def national_id_number_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d*$", value):
            raise ValueError(r"must validate the regular expression /^\d*$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SouthAfricaNidInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SouthAfricaNidInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fullName": obj.get("fullName"),
            "dateOfBirth": obj.get("dateOfBirth"),
            "gender": obj.get("gender"),
            "nationalIdNumber": obj.get("nationalIdNumber")
        })
        return _obj


