# coding: utf-8

"""
    Trinsic API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TrinsicTestDatabaseLookupInput(BaseModel):
    """
    TrinsicTestDatabaseLookupInput
    """ # noqa: E501
    given_name: Optional[StrictStr] = Field(default=None, description="The given name to use for the output of the test Session.              This is required; if not provided, Trinsic's Fallback UI will be invoked to collect it from the user.              Can be any non-empty value.", alias="givenName")
    family_name: Optional[StrictStr] = Field(default=None, description="The family name to use for the output of the test Session.              This is required; if not provided, Trinsic's Fallback UI will be invoked to collect it from the user.              Can be any non-empty value.", alias="familyName")
    identity_code: Optional[StrictStr] = Field(default=None, description="A 6-digit code; must be \"123456\" for the Session to succeed.              This is required; if not provided, Trinsic's Fallback UI will be invoked to collect it from the user.              Any other value will cause the Session to fail.", alias="identityCode")
    selfie_base64: Optional[StrictStr] = Field(default=None, description="An optional selfie image, base64-encoded.              Will replace the existing test selfie attachment output if provided.", alias="selfieBase64")
    __properties: ClassVar[List[str]] = ["givenName", "familyName", "identityCode", "selfieBase64"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TrinsicTestDatabaseLookupInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if given_name (nullable) is None
        # and model_fields_set contains the field
        if self.given_name is None and "given_name" in self.model_fields_set:
            _dict['givenName'] = None

        # set to None if family_name (nullable) is None
        # and model_fields_set contains the field
        if self.family_name is None and "family_name" in self.model_fields_set:
            _dict['familyName'] = None

        # set to None if identity_code (nullable) is None
        # and model_fields_set contains the field
        if self.identity_code is None and "identity_code" in self.model_fields_set:
            _dict['identityCode'] = None

        # set to None if selfie_base64 (nullable) is None
        # and model_fields_set contains the field
        if self.selfie_base64 is None and "selfie_base64" in self.model_fields_set:
            _dict['selfieBase64'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TrinsicTestDatabaseLookupInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "givenName": obj.get("givenName"),
            "familyName": obj.get("familyName"),
            "identityCode": obj.get("identityCode"),
            "selfieBase64": obj.get("selfieBase64")
        })
        return _obj


