# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/asana/00_auth.ipynb.

# %% ../../nbs/asana/00_auth.ipynb 2
from __future__ import annotations

from dataclasses import dataclass, field

import domolibrary_extensions.client as gd

# %% auto 0
__all__ = ['AsanaAuth']

# %% ../../nbs/asana/00_auth.ipynb 4
@dataclass
class AsanaAuth(gd.Auth):
    token: str = field(repr=False)
    workspace_id: str
    instance: str = field(repr=False, default=None)
    base_url = "https://app.asana.com/api/1.0"
    auth_header: dict = field(repr=False, default=None)

    def __post_init__(self):
        self.generate_auth_header()
        self.instance = self.workspace_id

    def get_auth_token(self):
        return self.token

    def generate_auth_header(self):
        self.auth_header = {
            "Authorization": f"Bearer {self.token}",
        }
        return self.auth_header

    async def who_am_i(self):
        url = f"{self.base_url}/users/me"
        res = await gd.get_data(method="get", url=url, auth=self)

        if not res.is_success:
            raise gd.BaseError(res=res)

        return res
