# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/asana/01_project.ipynb.

# %% ../../nbs/asana/01_project.ipynb 2
from __future__ import annotations
from typing import List, Any
from dataclasses import dataclass, field
from typing import List
import datetime as dt

from nbdev.showdoc import patch_to

import domolibrary_extensions.utils.utils as deut
import domolibrary_extensions.client as gd
import domolibrary_extensions.asana.auth as aa
import domolibrary_extensions.asana.user as au

# %% auto 0
__all__ = ['AsanaProject']

# %% ../../nbs/asana/01_project.ipynb 4
@dataclass
class AsanaProject:
    id: str
    name: str
    workspace_id: str
    permalink_url: str
    auth: aa.AsanaAuth = field(repr=False)

    is_archived: bool
    is_completed: bool

    created_date: dt.datetime
    modified_date: dt.datetime

    owner: au.AsanaUser
    members: List[au.AsanaUser]

    due_date: dt.datetime = None
    completed_date: dt.datetime = None

    asana_tasks: List[Any] = None  # AsanaTask

    @classmethod
    def _from_json(cls, obj, auth: aa.AsanaAuth):
        owner = (
            au.AsanaUser._from_json(obj.get("owner"), auth=auth)
            if obj.get("owner")
            else None
        )

        members = (
            [
                au.AsanaUser._from_json(member, auth=auth)
                for member in obj.get("members", [])
            ]
            if obj.get("members")
            else None
        )

        created_date = deut.convert_str_to_date(obj.get("created_at"))
        modified_date = deut.convert_str_to_date(obj.get("modified_at"))
        due_date = deut.convert_str_to_date(obj.get("due_on"))
        completed_date = deut.convert_str_to_date(obj.get("completed_at"))

        return cls(
            auth=auth,
            id=obj.get("gid"),
            name=obj.get("name"),
            workspace_id=obj.get("workspace", {}).get("gid"),
            permalink_url=obj.get("permalink_url"),
            is_archived=obj.get("archived"),
            is_completed=obj.get("completed"),
            created_date=created_date,
            modified_date=modified_date,
            owner=owner,
            members=members,
            due_date=due_date,
            completed_date=completed_date,
        )

# %% ../../nbs/asana/01_project.ipynb 5
@patch_to(AsanaProject, cls_method=True)
async def get_projects(
    cls: AsanaProject,
    auth: aa.AsanaAuth,
    debug_api: bool = False,
    return_raw: bool = False,
    timeout: int = 30,
):
    url = f"{auth.base_url}/projects"

    res = await gd.get_data(
        auth=auth, method="GET", url=url, debug_api=debug_api, timeout=timeout
    )

    if not res.is_success:
        raise gd.BaseError(res=res)

    if return_raw:
        return res

    return [
        AsanaProject._from_json(proj_obj, auth=auth)
        for proj_obj in res.response["data"]
    ]

# %% ../../nbs/asana/01_project.ipynb 8
@patch_to(AsanaProject, cls_method=True)
async def get_by_id(
    cls: AsanaProject,
    auth: aa.AsanaAuth,
    project_id,
    debug_api: bool = False,
    return_raw: bool = False,
    timeout: int = 30,
):
    url = f"{auth.base_url}/projects/{project_id}"

    res = await gd.get_data(
        auth=auth, method="GET", url=url, debug_api=debug_api, timeout=timeout
    )

    if not res.is_success:
        raise gd.BaseError(res=res)

    if return_raw:
        return res

    return cls._from_json(res.response["data"], auth=auth)

# %% ../../nbs/asana/01_project.ipynb 11
@patch_to(AsanaProject)
async def get_tasks(
    self: AsanaProject, debug_api: bool = False, return_raw: bool = False
):
    import domolibrary_extensions.asana.task as at

    auth = self.auth

    url = f"{auth.base_url}/projects/{self.id}/tasks"

    res = await gd.get_data(
        auth=auth,
        method="GET",
        url=url,
        debug_api=debug_api,
        params={
            "opt_fields": "custom_fields, gid, name, assignee, this.assignee.resource_type, this.assignee.email, this.assignee.name, completed, assignee_status, completed_at, created_at, due_on, modified_at, memberships, notes, parent, permalink_url, tags, projects, workspace, this.memberships.section.resource_type, this.memberships.section, this.memberships.project"
        },
    )

    if not res.is_success:
        raise gd.BaseError(res=res)

    if return_raw:
        return res

    self.asana_tasks = [
        at.AsanaTask._from_json(task_obj, auth=auth)
        for task_obj in res.response["data"]
    ]

    return self.asana_tasks
