"""classes and functions for using GPT to interact with ProxyCurl"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/integrations/proxycurl.ipynb.

# %% auto 0
__all__ = ['ProxyCurlAuth', 'get_linked_in_profile_route', 'scrape_linkedin_profile']

# %% ../../nbs/integrations/proxycurl.ipynb 3
from dataclasses import dataclass, field
import httpx
import inspect

import domolibrary_extensions.client as gd

# %% ../../nbs/integrations/proxycurl.ipynb 6
@dataclass
class ProxyCurlAuth(gd.Auth):
    """this library uses proxycurl to interact with LinkedIn APIs
    setup an account at https://proxycurl.com/
    """

    api_key: str = field(repr=False)  # key from proxycurl
    headers: dict = field(repr=False, default_factory=dict)

    def generate_auth_header(self):
        """interal method for generating a properly formatted proxycurl auth header"""
        return {"Authorization": f"Bearer {self.api_key}"}

# %% ../../nbs/integrations/proxycurl.ipynb 10
async def get_linked_in_profile_route(
    auth: ProxyCurlAuth,
    linkedin_profile_url: str = None,
    client: httpx.AsyncClient = None,
    cache_path: str = None,
    is_ignore_cache: bool = False,
    parent_class: str = None,
    debug_api: bool = False,
    debug_prn: bool = False,
):
    """gets a linkedin profiel via the proxycurl API"""

    url = "https://nubela.co/proxycurl/api/v2/linkedin"

    if not cache_path:
        url_id = url.replace("https://www.linkedin.com/in/", "")
        url_id = url_id.split("/")[0]
        cache_path = "CACHE\linkedin_profile_{url_id}.json"

    params = {
        "linkedin_profile_url": linkedin_profile_url,
        #     "twitter_profile_url": "https://twitter.com/johnrmarty/",
        #     "facebook_profile_url": "https://facebook.com/johnrmarty/",
        #     "extra": "include",
        #     "github_profile_id": "include",
        #     "facebook_profile_id": "include",
        #     "twitter_profile_id": "include",
        #     "personal_contact_number": "include",
        #     "personal_email": "include",
        #     "inferred_salary": "include",
        #     "skills": "include",
        #     "use_cache": "if-present",
        #     "fallback_to_cache": "on-error",
    }

    res = await gd.get_data(
        url=url,
        params=params,
        auth=auth,
        method="GET",
        client=client,
        cache_path=cache_path,
        is_ignore_cache=is_ignore_cache,
        parent_class=parent_class,
        debug_api=debug_api,
        debug_prn=debug_prn,
    )

    return res

# %% ../../nbs/integrations/proxycurl.ipynb 14
async def scrape_linkedin_profile(
    auth: ProxyCurlAuth,
    linkedin_profile_url: str = None,
    client: httpx.AsyncClient = None,
    cache_path: str = None,
    is_ignore_cache: bool = False,
    debug_api: bool = False,
    debug_prn: bool = False,
):
    """scrape information from LinkedIn profiles via proxy curl"""

    res = await get_linked_in_profile_route(
        auth=auth,
        linkedin_profile_url=linkedin_profile_url,
        client=client,
        cache_path=cache_path,
        is_ignore_cache=is_ignore_cache,
        debug_api=debug_api,
        debug_prn=debug_prn,
    )

    profile_obj = res.response

    profile_obj = {
        key: value
        for key, value in profile_obj.items()
        if value and key not in ["people_also_viewed", "certifications"]
    }

    if profile_obj.get("groups"):
        for group_obj in profile_obj["groups"]:
            group_obj.pop("profile_pic_url")

    return profile_obj
