# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/jira/routes.ipynb.

# %% auto 0
__all__ = ['get_boards', 'get_board_epics', 'get_epic', 'search_issues_jql', 'get_issue_by_id', 'get_board_issues',
           'get_issue_remotelinks', 'upsert_issue_remotelink', 'get_issue_links', 'get_issue_comments']

# %% ../../nbs/jira/routes.ipynb 2
import httpx

import urllib

import domolibrary_extensions.client as gd
import domolibrary_extensions.jira.auth as ja

# %% ../../nbs/jira/routes.ipynb 5
async def get_boards(
    auth: ja.JiraAuth,
    params: dict = None,
    debug_api: bool = False,
    debug_loop: bool = False,
    return_raw: bool = False,
    client: httpx.AsyncClient = None,
    is_ignore_cache: bool = False,
    cache_path: str = None,
    timeout: int = 30,
):
    url = f"https://{auth.instance}/rest/agile/1.0/board"

    def arr_fn(res):
        return res.response["values"]

    client = client or httpx.AsyncClient()

    res = await gd.looper(
        url=url,
        auth=auth,
        arr_fn=arr_fn,
        params=params,
        method="GET",
        debug_loop=debug_loop,
        debug_api=debug_api,
        client=client,
        is_ignore_cache=is_ignore_cache,
        cache_path=cache_path,
        timeout=timeout,
        return_raw=return_raw,
    )

    return res

# %% ../../nbs/jira/routes.ipynb 11
async def get_board_epics(
    auth: ja.JiraAuth,
    board_id: int,
    params: dict = None,
    is_ignore_cache: bool = False,
    cache_path: str = None,
    client: httpx.AsyncClient = None,
    timeout: int = 30,
    debug_api: bool = False,
    debug_loop: bool = False,
    return_raw: bool = False,
):
    url = f"https://{auth.instance}/rest/agile/1.0/board/{board_id}/epic"

    def arr_fn(res):
        return res.response["values"]

    res = await gd.looper(
        method="get",
        url=url,
        auth=auth,
        params=params,
        debug_api=debug_api,
        debug_loop=debug_loop,
        arr_fn=arr_fn,
        is_ignore_cache=is_ignore_cache,
        cache_path=cache_path,
        client=client,
        timeout=timeout,
        return_raw=return_raw,
    )

    if not res.is_success:
        raise gd.BaseError(res=res)

    return res

# %% ../../nbs/jira/routes.ipynb 14
async def get_epic(
    epic_id,
    auth: ja.JiraAuth,
    debug_api: bool = False,
    is_ignore_cache: bool = False,
    cache_path: str = None,
    client: httpx.AsyncClient = None,
    timeout: int = 30,
):
    url = f"https://{auth.instance}/rest/agile/1.0/epic/{epic_id}"

    res = await gd.get_data(
        method="get",
        url=url,
        auth=auth,
        debug_api=debug_api,
        is_ignore_cache=is_ignore_cache,
        cache_path=cache_path,
        client=client,
        timeout=timeout,
    )

    if not res.is_success:
        raise gd.BaseError(res=res)

    return res

# %% ../../nbs/jira/routes.ipynb 18
async def search_issues_jql(
    auth: ja.JiraAuth,
    jql: str,
    params: dict = None,
    debug_api: bool = False,
    return_raw: bool = False,
    client: httpx.AsyncClient = None,
    is_ignore_cache: bool = False,
    cache_path: str = None,
):
    params = params or {}

    url = f"https://{auth.instance}/rest/api/2/search?"

    res = await gd.get_data(
        url=url,
        auth=auth,
        method="GET",
        debug_api=debug_api,
        params={**params, "jql": urllib.parse.quote(jql)},
        client=client,
        is_ignore_cache=is_ignore_cache,
        cache_path=cache_path,
    )

    if not res.is_success:
        raise gd.BaseError(res=res)

    if return_raw:
        return res

    res.response = res.response["issues"]

    return res

# %% ../../nbs/jira/routes.ipynb 19
async def get_issue_by_id(
    auth: ja.JiraAuth,
    issue_id: int,
    debug_api: bool = False,
    is_ignore_cache: bool = False,
    cache_path: str = None,
    client: httpx.AsyncClient = None,
    timeout: int = 30,
):
    url = f"https://{auth.instance}/rest/api/2/issue/{issue_id}"

    res = await gd.get_data(
        method="get",
        url=url,
        auth=auth,
        debug_api=debug_api,
        is_ignore_cache=is_ignore_cache,
        cache_path=cache_path,
        client=client,
        timeout=timeout,
    )

    if not res.is_success:
        raise gd.BaseError(res=res)

    return res

# %% ../../nbs/jira/routes.ipynb 20
async def get_board_issues(
    auth: ja.JiraAuth,
    board_id: int,
    params: dict = None,
    debug_api: bool = False,
    debug_loop: bool = False,
    return_raw: bool = False,
    is_ignore_cache: bool = False,
    cache_path: str = None,
    client: httpx.AsyncClient = None,
    timeout: int = 30,
):
    url = f"https://{auth.instance}/rest/agile/1.0/board/{board_id}/issue"

    def arr_fn(res):
        return res.response["issues"]

    res = await gd.looper(
        method="get",
        url=url,
        auth=auth,
        params=params,
        offset_params={"offset": "startAt", "limit": "maxResults"},
        offset_params_is_header=True,
        debug_api=debug_api,
        debug_loop=debug_loop,
        arr_fn=arr_fn,
        is_ignore_cache=is_ignore_cache,
        cache_path=cache_path,
        client=client,
        timeout=timeout,
        return_raw=return_raw,
    )

    if not res.is_success:
        raise gd.BaseError(res=res)

    return res

# %% ../../nbs/jira/routes.ipynb 21
async def get_issue_remotelinks(
    auth: ja.JiraAuth,
    issue_id: int,
    debug_api: bool = False,
    is_ignore_cache: bool = False,
    cache_path: str = None,
    client: httpx.AsyncClient = None,
    timeout: int = 30,
):
    # url = f'https://{auth.instance}/rest/api/2/issueLink'
    url = f"https://{auth.instance}/rest/api/2/issue/{issue_id}/remotelink"

    res = await gd.get_data(
        method="get",
        url=url,
        auth=auth,
        debug_api=debug_api,
        is_ignore_cache=is_ignore_cache,
        cache_path=cache_path,
        client=client,
        timeout=timeout,
    )

    return res

# %% ../../nbs/jira/routes.ipynb 22
async def upsert_issue_remotelink(
    issue_id,
    body,
    auth: ja.JiraAuth,
    debug_api: bool = False,
    is_ignore_cache: bool = False,
    cache_path: str = None,
    client: httpx.AsyncClient = None,
    timeout: int = 30,
):

    url = f"https://{auth.instance}/rest/api/latest/issue/{issue_id}/remotelink"

    res = await gd.get_data(
        method="post",
        url=url,
        body=body,
        auth=auth,
        headers={"Content-Type": "application/json"},
        debug_api=debug_api,
        is_ignore_cache=is_ignore_cache,
        cache_path=cache_path,
        client=client,
        timeout=timeout,
    )

    return res

# %% ../../nbs/jira/routes.ipynb 23
async def get_issue_links(
    auth,
    issue_id: int,
    debug_api: bool = False,
    return_raw: bool = False,
    is_ignore_cache: bool = False,
    cache_path: str = None,
    client: httpx.AsyncClient = None,
    timeout: int = 30,
):
    url = f"https://{auth.instance}/rest/api/2/issue/{issue_id}?fields=issuelinks,customfield_10940"
    # ,parentIssuesOf

    res = await gd.get_data(
        method="get",
        url=url,
        auth=auth,
        debug_api=debug_api,
        is_ignore_cache=is_ignore_cache,
        cache_path=cache_path,
        client=client,
        # body = {"expand" : 'links'},
        timeout=timeout,
    )

    if return_raw:
        return res

    fields = res.response["fields"]

    parent_id = fields.get("customfield_10940")

    issuelinks = fields["issuelinks"]

    il = [
        {
            "url": f"https://{auth.instance}/browse/{link['inwardIssue']['key']}",
            "id": link["inwardIssue"]["key"],
            "type": link["type"]["inward"],
            "status": link["inwardIssue"]["fields"]["status"]["name"],
            "title": link["inwardIssue"]["fields"]["summary"],
        }
        for link in issuelinks
    ]

    res.response = {
        "parent_epic": (
            {"id": parent_id, "url": f"https://{auth.instance}/browse/{parent_id}"}
            if parent_id
            else None
        ),
        "issue_links": il,
    }

    return res

# %% ../../nbs/jira/routes.ipynb 24
async def get_issue_comments(
    issue_id,
    auth: ja.JiraAuth,
    debug_api: bool = False,
    return_raw: bool = False,
    is_ignore_cache: bool = False,
    cache_path: str = None,
    client: httpx.AsyncClient = None,
    timeout: int = 30,
):
    url = (
        f"https://{auth.instance}/rest/api/2/issue/{issue_id}/comment?orderBy=-created&maxResults=0&expand=renderedBody"
        if auth.is_datacenter
        else f"https://{auth.instance}/rest/api/2/issue/{issue_id}/comment?orderBy=-created&maxResults=0&expand=renderedBody"
    )

    def arr_fn(res):
        return res.response["comments"]

    res = await gd.looper(
        method="get",
        url=url,
        auth=auth,
        arr_fn=arr_fn,
        offset_params={"offset": "startAt", "limit": "maxResults"},
        offset_params_is_header=True,
        debug_api=debug_api,
        is_ignore_cache=is_ignore_cache,
        cache_path=cache_path,
        client=client,
        timeout=timeout,
        return_raw=return_raw,
    )

    return res
