"""2024.5.0 ajout d'un champ sur les notifications

Create Date: 2024-11-13 14:50:17.758370

"""

# revision identifiers, used by Alembic.

# Revision ID:
revision = "2eb7be665f50"

# Revises (previous revision or revisions):
down_revision = "1d03880a1ae3"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "notification_event",
        sa.Column("account_type", sa.String(length=20), nullable=True),
    )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("notification_event", "account_type")
