"""2025.5.3 SMTP 'reply_to' nullable

Create Date: 2025-09-22 13:55:30.434195

"""

# revision identifiers, used by Alembic.

# Revision ID:
revision = "3fc875364294"

# Revises (previous revision or revisions):
down_revision = "2afc8ac82521"

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "node_smtp_history",
        "reply_to",
        existing_type=mysql.VARCHAR(length=255),
        nullable=True,
    )
    op.alter_column(
        "node_smtp_history",
        "sender_label",
        existing_type=mysql.VARCHAR(length=255),
        nullable=True,
    )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from caerp_base.models.base import DBSESSION
    from zope.sqlalchemy import mark_changed

    session = DBSESSION()
    conn = get_bind()

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "node_smtp_history",
        "reply_to",
        existing_type=mysql.VARCHAR(length=255),
        nullable=False,
    )
    op.alter_column(
        "node_smtp_history",
        "sender_label",
        existing_type=mysql.VARCHAR(length=255),
        nullable=False,
    )
    # ### end Alembic commands ###
