"""5.0 catalogue produit

Revision ID: 414d467360af
Revises: 3fa5e47992bf
Create Date: 2019-04-09 19:34:26.685472

"""

# revision identifiers, used by Alembic.
revision = "414d467360af"
down_revision = "3fa5e47992bf"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    print("Updating the database structure")
    ### commands auto generated by Alembic - please adjust! ###
    op.add_column("sale_product", sa.Column("company_id", sa.Integer(), nullable=True))
    op.execute(
        "update sale_product set company_id=(select company_id from sale_product_category where sale_product_category.id=sale_product.category_id);"
    )
    print("Done")
    ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION
    from zope.sqlalchemy import mark_changed

    session = DBSESSION()
    mark_changed(session)
    from alembic.context import get_bind

    conn = get_bind()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        op.f("fk_sale_product_company_id"), "sale_product", type_="foreignkey"
    )
    op.drop_column("sale_product", "company_id")
    ### end Alembic commands ###
