"""5.0 price_study

Revision ID: ad33637b0b1a
Revises: eba300f6604a
Create Date: 2019-06-13 14:37:32.905369

"""

# revision identifiers, used by Alembic.
revision = "ad33637b0b1a"
down_revision = "eba300f6604a"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "project_type", sa.Column("include_price_study", sa.Boolean(), nullable=True)
    )
    op.add_column("task", sa.Column("price_study_id", sa.Integer(), nullable=True))

    op.create_foreign_key(
        op.f("fk_task_price_study_id"),
        "task",
        "price_study",
        ["price_study_id"],
        ["id"],
    )

    # ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION
    from zope.sqlalchemy import mark_changed

    session = DBSESSION()
    mark_changed(session)
    from alembic.context import get_bind

    conn = get_bind()
    conn.execute("update project_type set include_price_study='0'")
    conn.execute(
        "update project_type set include_price_study='1' " "where label='Chantiers'"
    )


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    op.drop_column("project_type", "include_price_study")
    op.drop_constraint(op.f("fk_task_price_study_id"), "task", type_="foreignkey")
    op.drop_column("task", "price_study_id")
