"""5.1 Added mode to Task and ttc to TaskLine models

Revision ID: 273d4944c9e0
Revises: e7e675528508
Create Date: 2019-09-11 11:03:07.258387

"""

# revision identifiers, used by Alembic.
revision = "273d4944c9e0"
down_revision = "e7e675528508"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("task", sa.Column("mode", sa.String(length=10), nullable=True))
    op.add_column("task_line", sa.Column("mode", sa.String(length=10), nullable=True))
    op.add_column("project", sa.Column("mode", sa.String(length=10), nullable=True))
    # ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from alembic.context import get_bind

    conn = get_bind()
    op.execute("UPDATE task SET mode='ht'")
    op.execute("UPDATE task_line SET mode='ht'")
    op.execute("UPDATE project SET mode='ht'")


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("task_line", "mode")
    op.drop_column("task", "mode")
    op.drop_column("project", "mode")
    # ### end Alembic commands ###
